/*
 * Decompiled with CFR 0.152.
 */
package org.mangosdk.spi.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mangosdk.spi.processor.Initializer;
import org.mangosdk.spi.processor.LogLocation;
import org.mangosdk.spi.processor.Logger;
import org.mangosdk.spi.processor.Service;

final class Collector {
    private final Map<String, Service> services = new HashMap<String, Service>();
    private final List<String> removed = new ArrayList<String>();
    private final Initializer initializer;
    private final Logger logger;

    Collector(Initializer initializer, Logger logger) {
        this.initializer = initializer;
        this.logger = logger;
    }

    Service getService(String service) {
        if (service == null) {
            throw new NullPointerException("service");
        }
        if (!this.services.containsKey(service)) {
            Service newService = new Service(this.logger, service);
            CharSequence initialData = this.initializer.initialData(service);
            if (initialData != null) {
                newService.fromProviderNamesList(((Object)initialData).toString());
                for (String provider : this.removed) {
                    newService.removeProvider(provider);
                }
            }
            this.services.put(service, newService);
        }
        return this.services.get(service);
    }

    Collection<Service> services() {
        return Collections.unmodifiableMap(this.services).values();
    }

    void removeProvider(String provider) {
        if (provider == null) {
            throw new NullPointerException("provider");
        }
        this.logger.note(LogLocation.LOG_FILE, "Removing " + provider);
        this.removed.add(provider);
        for (Service service : this.services.values()) {
            service.removeProvider(provider);
        }
    }

    public String toString() {
        return this.services.values().toString();
    }
}

