/*
 * Decompiled with CFR 0.152.
 */
package org.mangosdk.spi.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.mangosdk.spi.processor.LogLocation;
import org.mangosdk.spi.processor.Logger;

final class Service {
    private final Logger logger;
    private final String serviceName;
    private final Set<String> providers = new HashSet<String>();

    Service(Logger logger, String name) {
        if (logger == null) {
            throw new NullPointerException("logger");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.logger = logger;
        logger.note(LogLocation.LOG_FILE, "Creating " + name);
        this.serviceName = name;
    }

    void addProvider(String provider) {
        if (provider == null) {
            throw new NullPointerException("provider");
        }
        this.logger.note(LogLocation.LOG_FILE, "Adding " + provider + " to " + this.serviceName);
        this.providers.add(provider);
    }

    boolean contains(String provider) {
        return this.providers.contains(provider);
    }

    boolean removeProvider(String provider) {
        if (this.providers.remove(provider)) {
            this.logger.note(LogLocation.LOG_FILE, "Removing " + provider + " from " + this.serviceName);
            return true;
        }
        return false;
    }

    String getName() {
        return this.serviceName;
    }

    String toProviderNamesList() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> names = new ArrayList<String>(this.providers);
        Collections.sort(names);
        for (String provider : names) {
            sb.append(provider).append("\n");
        }
        return sb.toString();
    }

    void fromProviderNamesList(String input) {
        String[] lines;
        if (input == null) {
            throw new NullPointerException("input");
        }
        for (String line : lines = input.split("\\n")) {
            String trimmed;
            String[] content = line.split("#");
            if (content.length <= 0 || (trimmed = content[0].trim()).length() <= 0) continue;
            this.addProvider(trimmed);
        }
    }

    public String toString() {
        return this.serviceName + "=" + this.providers;
    }
}

