/*
 * Decompiled with CFR 0.152.
 */
package fastrf;

import ca.ubc.cs.beta.models.fastrf.RandomForest;
import ca.ubc.cs.beta.models.fastrf.RegtreeBuildParams;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class fastrf {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void test() {
        int[] catDomainSizes = new int[]{2, 0, 0};
        RegtreeBuildParams buildparams = new RegtreeBuildParams(false, 1, 1.0, catDomainSizes);
        buildparams.random = new Random(3L);
        buildparams.catDomainSizes = catDomainSizes;
        buildparams.minVariance = Math.pow(10.0, -14.0);
        buildparams.ratioFeatures = 1.0;
        buildparams.nameConditionsMapOp = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsArray = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsValues = new HashMap<Integer, double[][][]>();
        int numTrees = 10;
        double[][] allTheta = new double[][]{{1.0, 0.0}, {2.0, 0.0}};
        double[][] allX = new double[][]{{0.0}, {1.0}};
        int[][] theta_inst_idxs = new int[][]{{0, 0}, {1, 1}, {0, 1}, {1, 0}};
        double[] y = new double[]{4.0, 1.0, 5.0, 2.0};
        RandomForest rf = RandomForest.learnModel(numTrees, allTheta, allX, theta_inst_idxs, y, buildparams);
        double[][] x = new double[][]{{1.0, 1.0, 0.0}, {2.0, 0.0, 0.0}, {1.0, 1.0, 1.0}};
        double[][] pred = RandomForest.apply(rf, x);
        System.out.println(Arrays.deepToString((Object[])pred));
    }

    @Test
    public void testEQContNonActive() {
        int[] catDomainSizes = new int[]{2, 0, 0};
        RegtreeBuildParams buildparams = new RegtreeBuildParams(false, 1, 1.0, catDomainSizes);
        buildparams.random = new Random(3L);
        buildparams.minVariance = Math.pow(10.0, -14.0);
        buildparams.ratioFeatures = 1.0;
        buildparams.nameConditionsMapOp = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsArray = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsValues = new HashMap<Integer, double[][][]>();
        int[][] op = new int[][]{{0}};
        buildparams.nameConditionsMapOp.put(0, op);
        int[][] par = new int[][]{{1}};
        buildparams.nameConditionsMapParentsArray.put(0, par);
        double[][][] val = new double[][][]{new double[][]{{1.0}}};
        buildparams.nameConditionsMapParentsValues.put(0, val);
        int numTrees = 10;
        double[][] allTheta = new double[][]{{1.0, 0.0}, {2.0, 0.0}};
        double[][] allX = new double[][]{{0.0}, {0.0}};
        int[][] theta_inst_idxs = new int[][]{{0, 0}, {1, 1}, {0, 1}, {1, 0}};
        double[] y = new double[]{4.0, 1.0, 5.0, 2.0};
        RandomForest rf = RandomForest.learnModel(numTrees, allTheta, allX, theta_inst_idxs, y, buildparams);
        double[][] x = new double[][]{{1.0, 1.0, 0.0}, {2.0, 0.0, 0.0}, {1.0, 1.0, 1.0}};
        double[][] pred = RandomForest.apply(rf, x);
        System.out.println("EQ NonActive Test:");
        System.out.println(Arrays.deepToString((Object[])pred));
        Assert.assertTrue((pred[0][0] == pred[1][0] ? 1 : 0) != 0);
        Assert.assertTrue((pred[2][0] == pred[1][0] ? 1 : 0) != 0);
    }

    @Test
    public void testNEQCont() {
        int[] catDomainSizes = new int[]{2, 0, 0};
        RegtreeBuildParams buildparams = new RegtreeBuildParams(false, 1, 1.0, catDomainSizes);
        buildparams.catDomainSizes = catDomainSizes;
        buildparams.minVariance = Math.pow(10.0, -14.0);
        buildparams.ratioFeatures = 1.0;
        buildparams.nameConditionsMapOp = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsArray = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsValues = new HashMap<Integer, double[][][]>();
        int[][] op = new int[][]{{1}};
        buildparams.nameConditionsMapOp.put(0, op);
        int[][] par = new int[][]{{1}};
        buildparams.nameConditionsMapParentsArray.put(0, par);
        double[][][] val = new double[][][]{new double[][]{{2.0}}};
        buildparams.nameConditionsMapParentsValues.put(0, val);
        int numTrees = 10;
        double[][] allTheta = new double[][]{{1.0, 0.0}, {2.0, 0.0}};
        double[][] allX = new double[][]{{0.0}, {0.0}};
        int[][] theta_inst_idxs = new int[][]{{0, 0}, {1, 1}, {0, 1}, {1, 0}};
        double[] y = new double[]{4.0, 1.0, 5.0, 2.0};
        RandomForest rf = RandomForest.learnModel(numTrees, allTheta, allX, theta_inst_idxs, y, buildparams);
        double[][] x = new double[][]{{1.0, 1.0, 0.0}, {2.0, 0.0, 0.0}, {1.0, 1.0, 1.0}};
        double[][] pred = RandomForest.apply(rf, x);
        System.out.println("NEQ Test:");
        System.out.println(Arrays.deepToString((Object[])pred));
        Assert.assertTrue((pred[0][0] == pred[2][0] ? 1 : 0) != 0);
        Assert.assertTrue((pred[1][0] != pred[2][0] ? 1 : 0) != 0);
    }

    @Test
    public void testNEQContNonActive() {
        int[] catDomainSizes = new int[]{2, 0, 0};
        RegtreeBuildParams buildparams = new RegtreeBuildParams(false, 1, 1.0, catDomainSizes);
        buildparams.minVariance = Math.pow(10.0, -14.0);
        buildparams.ratioFeatures = 1.0;
        buildparams.nameConditionsMapOp = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsArray = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsValues = new HashMap<Integer, double[][][]>();
        int[][] op = new int[][]{{1}};
        buildparams.nameConditionsMapOp.put(0, op);
        int[][] par = new int[][]{{1}};
        buildparams.nameConditionsMapParentsArray.put(0, par);
        double[][][] val = new double[][][]{new double[][]{{0.0}}};
        buildparams.nameConditionsMapParentsValues.put(0, val);
        int numTrees = 10;
        double[][] allTheta = new double[][]{{1.0, 0.0}, {2.0, 0.0}};
        double[][] allX = new double[][]{{0.0}, {0.0}};
        int[][] theta_inst_idxs = new int[][]{{0, 0}, {1, 1}, {0, 1}, {1, 0}};
        double[] y = new double[]{4.0, 1.0, 5.0, 2.0};
        RandomForest rf = RandomForest.learnModel(numTrees, allTheta, allX, theta_inst_idxs, y, buildparams);
        double[][] x = new double[][]{{1.0, 1.0, 0.0}, {2.0, 0.0, 0.0}, {1.0, 1.0, 1.0}};
        double[][] pred = RandomForest.apply(rf, x);
        System.out.println("NEQ NonActive Test:");
        System.out.println(Arrays.deepToString((Object[])pred));
        Assert.assertTrue((pred[0][0] == pred[1][0] ? 1 : 0) != 0);
        Assert.assertTrue((pred[2][0] == pred[1][0] ? 1 : 0) != 0);
    }

    @Test
    public void testLECont() {
        int[] catDomainSizes = new int[]{2, 0, 0};
        RegtreeBuildParams buildparams = new RegtreeBuildParams(false, 1, 1.0, catDomainSizes);
        buildparams.catDomainSizes = catDomainSizes;
        buildparams.minVariance = Math.pow(10.0, -14.0);
        buildparams.ratioFeatures = 1.0;
        buildparams.nameConditionsMapOp = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsArray = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsValues = new HashMap<Integer, double[][][]>();
        int[][] op = new int[][]{{2}};
        buildparams.nameConditionsMapOp.put(0, op);
        int[][] par = new int[][]{{1}};
        buildparams.nameConditionsMapParentsArray.put(0, par);
        double[][][] val = new double[][][]{new double[][]{{1.0}}};
        buildparams.nameConditionsMapParentsValues.put(0, val);
        int numTrees = 10;
        double[][] allTheta = new double[][]{{1.0, 0.0}, {2.0, 0.0}};
        double[][] allX = new double[][]{{0.0}, {0.0}};
        int[][] theta_inst_idxs = new int[][]{{0, 0}, {1, 1}, {0, 1}, {1, 0}};
        double[] y = new double[]{4.0, 1.0, 5.0, 2.0};
        RandomForest rf = RandomForest.learnModel(numTrees, allTheta, allX, theta_inst_idxs, y, buildparams);
        double[][] x = new double[][]{{1.0, 1.0, 0.0}, {2.0, 0.0, 0.0}, {1.0, 1.0, 1.0}};
        double[][] pred = RandomForest.apply(rf, x);
        System.out.println("LE Test:");
        System.out.println(Arrays.deepToString((Object[])pred));
        Assert.assertTrue((pred[0][0] == pred[2][0] ? 1 : 0) != 0);
        Assert.assertTrue((pred[1][0] != pred[2][0] ? 1 : 0) != 0);
    }

    @Test
    public void testLEContNonActive() {
        int[] catDomainSizes = new int[]{2, 0, 0};
        RegtreeBuildParams buildparams = new RegtreeBuildParams(false, 1, 1.0, catDomainSizes);
        buildparams.minVariance = Math.pow(10.0, -14.0);
        buildparams.ratioFeatures = 1.0;
        buildparams.nameConditionsMapOp = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsArray = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsValues = new HashMap<Integer, double[][][]>();
        int[][] op = new int[][]{{2}};
        buildparams.nameConditionsMapOp.put(0, op);
        int[][] par = new int[][]{{1}};
        buildparams.nameConditionsMapParentsArray.put(0, par);
        double[][][] val = new double[][][]{new double[][]{{0.0}}};
        buildparams.nameConditionsMapParentsValues.put(0, val);
        int numTrees = 10;
        double[][] allTheta = new double[][]{{1.0, 0.0}, {2.0, 0.0}};
        double[][] allX = new double[][]{{0.0}, {0.0}};
        int[][] theta_inst_idxs = new int[][]{{0, 0}, {1, 1}, {0, 1}, {1, 0}};
        double[] y = new double[]{4.0, 1.0, 5.0, 2.0};
        RandomForest rf = RandomForest.learnModel(numTrees, allTheta, allX, theta_inst_idxs, y, buildparams);
        double[][] x = new double[][]{{1.0, 1.0, 0.0}, {2.0, 0.0, 0.0}, {1.0, 1.0, 1.0}};
        double[][] pred = RandomForest.apply(rf, x);
        System.out.println("LE NonActive Test:");
        System.out.println(Arrays.deepToString((Object[])pred));
        Assert.assertTrue((pred[0][0] == pred[1][0] ? 1 : 0) != 0);
        Assert.assertTrue((pred[2][0] == pred[1][0] ? 1 : 0) != 0);
    }

    @Test
    public void testGRCont() {
        int[] catDomainSizes = new int[]{2, 0, 0};
        RegtreeBuildParams buildparams = new RegtreeBuildParams(false, 1, 1.0, catDomainSizes);
        buildparams.minVariance = Math.pow(10.0, -14.0);
        buildparams.ratioFeatures = 1.0;
        buildparams.nameConditionsMapOp = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsArray = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsValues = new HashMap<Integer, double[][][]>();
        int[][] op = new int[][]{{3}};
        buildparams.nameConditionsMapOp.put(0, op);
        int[][] par = new int[][]{{1}};
        buildparams.nameConditionsMapParentsArray.put(0, par);
        double[][][] val = new double[][][]{new double[][]{{-0.5}}};
        buildparams.nameConditionsMapParentsValues.put(0, val);
        int numTrees = 10;
        double[][] allTheta = new double[][]{{1.0, 0.0}, {2.0, 0.0}};
        double[][] allX = new double[][]{{0.0}, {0.0}};
        int[][] theta_inst_idxs = new int[][]{{0, 0}, {1, 1}, {0, 1}, {1, 0}};
        double[] y = new double[]{4.0, 1.0, 5.0, 2.0};
        RandomForest rf = RandomForest.learnModel(numTrees, allTheta, allX, theta_inst_idxs, y, buildparams);
        double[][] x = new double[][]{{1.0, 1.0, 0.0}, {2.0, 0.0, 0.0}, {1.0, 1.0, 1.0}};
        double[][] pred = RandomForest.apply(rf, x);
        System.out.println("GR Test:");
        System.out.println(Arrays.deepToString((Object[])pred));
        Assert.assertTrue((pred[0][0] == pred[2][0] ? 1 : 0) != 0);
        Assert.assertTrue((pred[1][0] != pred[2][0] ? 1 : 0) != 0);
    }

    @Test
    public void testGRContNonActive() {
        int[] catDomainSizes = new int[]{2, 0, 0};
        RegtreeBuildParams buildparams = new RegtreeBuildParams(false, 1, 1.0, catDomainSizes);
        buildparams.minVariance = Math.pow(10.0, -14.0);
        buildparams.ratioFeatures = 1.0;
        buildparams.nameConditionsMapOp = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsArray = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsValues = new HashMap<Integer, double[][][]>();
        int[][] op = new int[][]{{3}};
        buildparams.nameConditionsMapOp.put(0, op);
        int[][] par = new int[][]{{1}};
        buildparams.nameConditionsMapParentsArray.put(0, par);
        double[][][] val = new double[][][]{new double[][]{{1.0}}};
        buildparams.nameConditionsMapParentsValues.put(0, val);
        int numTrees = 10;
        double[][] allTheta = new double[][]{{1.0, 0.0}, {2.0, 0.0}};
        double[][] allX = new double[][]{{0.0}, {0.0}};
        int[][] theta_inst_idxs = new int[][]{{0, 0}, {1, 1}, {0, 1}, {1, 0}};
        double[] y = new double[]{4.0, 1.0, 5.0, 2.0};
        RandomForest rf = RandomForest.learnModel(numTrees, allTheta, allX, theta_inst_idxs, y, buildparams);
        double[][] x = new double[][]{{1.0, 1.0, 0.0}, {2.0, 0.0, 0.0}, {1.0, 1.0, 1.0}};
        double[][] pred = RandomForest.apply(rf, x);
        System.out.println("GR NonActive Test:");
        System.out.println(Arrays.deepToString((Object[])pred));
        Assert.assertTrue((pred[0][0] == pred[1][0] ? 1 : 0) != 0);
        Assert.assertTrue((pred[2][0] == pred[1][0] ? 1 : 0) != 0);
    }

    @Test
    public void testINContNonActive() {
        int[] catDomainSizes = new int[]{2, 1, 0};
        RegtreeBuildParams buildparams = new RegtreeBuildParams(false, 1, 1.0, catDomainSizes);
        buildparams.minVariance = Math.pow(10.0, -14.0);
        buildparams.ratioFeatures = 1.0;
        buildparams.nameConditionsMapOp = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsArray = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsValues = new HashMap<Integer, double[][][]>();
        int[][] op = new int[][]{{4}};
        buildparams.nameConditionsMapOp.put(0, op);
        int[][] par = new int[][]{{1}};
        buildparams.nameConditionsMapParentsArray.put(0, par);
        double[][][] val = new double[][][]{new double[][]{{2.0, 3.0}}};
        buildparams.nameConditionsMapParentsValues.put(0, val);
        int numTrees = 10;
        double[][] allTheta = new double[][]{{1.0, 1.0}, {2.0, 1.0}};
        double[][] allX = new double[][]{{0.0}, {0.0}};
        int[][] theta_inst_idxs = new int[][]{{0, 0}, {1, 1}, {0, 1}, {1, 0}};
        double[] y = new double[]{4.0, 1.0, 5.0, 2.0};
        RandomForest rf = RandomForest.learnModel(numTrees, allTheta, allX, theta_inst_idxs, y, buildparams);
        double[][] x = new double[][]{{1.0, 1.0, 0.0}, {2.0, 0.0, 0.0}, {1.0, 1.0, 1.0}};
        double[][] pred = RandomForest.apply(rf, x);
        System.out.println("IN NonActive Test:");
        System.out.println(Arrays.deepToString((Object[])pred));
        Assert.assertTrue((pred[0][0] == pred[1][0] ? 1 : 0) != 0);
        Assert.assertTrue((pred[2][0] == pred[1][0] ? 1 : 0) != 0);
    }

    @Test
    public void testINCont() {
        int[] catDomainSizes = new int[]{2, 1, 0};
        RegtreeBuildParams buildparams = new RegtreeBuildParams(false, 1, 1.0, catDomainSizes);
        buildparams.minVariance = Math.pow(10.0, -14.0);
        buildparams.ratioFeatures = 1.0;
        buildparams.nameConditionsMapOp = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsArray = new HashMap<Integer, int[][]>();
        buildparams.nameConditionsMapParentsValues = new HashMap<Integer, double[][][]>();
        int[][] op = new int[][]{{4}};
        buildparams.nameConditionsMapOp.put(0, op);
        int[][] par = new int[][]{{1}};
        buildparams.nameConditionsMapParentsArray.put(0, par);
        double[][][] val = new double[][][]{new double[][]{{1.0}}};
        buildparams.nameConditionsMapParentsValues.put(0, val);
        int numTrees = 10;
        double[][] allTheta = new double[][]{{1.0, 1.0}, {2.0, 1.0}};
        double[][] allX = new double[][]{{0.0}, {0.0}};
        int[][] theta_inst_idxs = new int[][]{{0, 0}, {1, 1}, {0, 1}, {1, 0}};
        double[] y = new double[]{4.0, 1.0, 5.0, 2.0};
        RandomForest rf = RandomForest.learnModel(numTrees, allTheta, allX, theta_inst_idxs, y, buildparams);
        double[][] x = new double[][]{{1.0, 1.0, 0.0}, {2.0, 0.0, 0.0}, {1.0, 1.0, 1.0}};
        double[][] pred = RandomForest.apply(rf, x);
        System.out.println("IN Test:");
        System.out.println(Arrays.deepToString((Object[])pred));
        Assert.assertTrue((pred[0][0] == pred[2][0] ? 1 : 0) != 0);
        Assert.assertTrue((pred[1][0] != pred[2][0] ? 1 : 0) != 0);
    }

    public static enum B {
        a,
        b;

    }

    public static enum A {
        a,
        b;

    }
}

