/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.smac.configurator;

import ca.ubc.cs.beta.aeatk.acquisitionfunctions.AcquisitionFunction;
import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.eventsystem.EventManager;
import ca.ubc.cs.beta.aeatk.initialization.InitializationProcedure;
import ca.ubc.cs.beta.aeatk.misc.associatedvalue.ParamWithEI;
import ca.ubc.cs.beta.aeatk.misc.cputime.CPUTime;
import ca.ubc.cs.beta.aeatk.misc.math.ArrayMathOps;
import ca.ubc.cs.beta.aeatk.misc.watch.AutoStartStopWatch;
import ca.ubc.cs.beta.aeatk.model.builder.AdaptiveCappingModelBuilder;
import ca.ubc.cs.beta.aeatk.model.builder.BasicModelBuilder;
import ca.ubc.cs.beta.aeatk.model.data.MaskCensoredDataAsUncensored;
import ca.ubc.cs.beta.aeatk.model.data.MaskInactiveConditionalParametersWithDefaults;
import ca.ubc.cs.beta.aeatk.model.data.PCAModelDataSanitizer;
import ca.ubc.cs.beta.aeatk.model.data.SanitizedModelData;
import ca.ubc.cs.beta.aeatk.objectives.RunObjective;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.tracking.ParamConfigurationOriginTracker;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aeatk.random.SeedableRandomPool;
import ca.ubc.cs.beta.aeatk.random.SeedableRandomPoolConstants;
import ca.ubc.cs.beta.aeatk.runhistory.RunHistory;
import ca.ubc.cs.beta.aeatk.runhistory.RunHistoryHelper;
import ca.ubc.cs.beta.aeatk.runhistory.ThreadSafeRunHistory;
import ca.ubc.cs.beta.aeatk.smac.SMACOptions;
import ca.ubc.cs.beta.aeatk.state.StateFactory;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.termination.CompositeTerminationCondition;
import ca.ubc.cs.beta.models.fastrf.RandomForest;
import ca.ubc.cs.beta.smac.configurator.AbstractAlgorithmFramework;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialModelBasedAlgorithmConfiguration
extends AbstractAlgorithmFramework {
    private final int numPCA;
    private final boolean logModel;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SMACOptions smacConfig;
    private RandomForest forest;
    private RandomForest preparedForest;
    private SanitizedModelData sanitizedData;
    private final AcquisitionFunction ei;
    private static final boolean SELECT_CONFIGURATION_SYNC_DEBUGGING = false;
    private final RunHistory modelRunHistory;
    private final ExponentialDistribution exp;
    private double subsamplePercentage = 1.0;

    public SequentialModelBasedAlgorithmConfiguration(SMACOptions smacConfig, AlgorithmExecutionConfiguration execConfig, List<ProblemInstance> instances, TargetAlgorithmEvaluator algoEval, AcquisitionFunction ei, StateFactory sf, ParameterConfigurationSpace configSpace, InstanceSeedGenerator instanceSeedGen, ParameterConfiguration initialConfiguration, List<ParameterConfiguration> initialChallengers, EventManager eventManager, ThreadSafeRunHistory rh, SeedableRandomPool pool, CompositeTerminationCondition termCond, ParamConfigurationOriginTracker configTracker, InitializationProcedure initProc, RunHistory modelRH, CPUTime cpuTime) {
        super(smacConfig, execConfig, instances, algoEval, sf, configSpace, instanceSeedGen, initialConfiguration, initialChallengers, eventManager, rh, pool, termCond, configTracker, initProc, cpuTime);
        this.numPCA = smacConfig.numPCA;
        this.logModel = smacConfig.randomForestOptions.logModel;
        this.smacConfig = smacConfig;
        this.ei = ei;
        if (modelRH.getAlgorithmRunDataExcludingRedundant().size() > 0) {
            this.log.debug("Model warmstart payload detected with {} runs ", (Object)modelRH.getAlgorithmRunDataExcludingRedundant().size());
        }
        this.modelRunHistory = modelRH;
        MersenneTwister prng = new MersenneTwister(pool.getSeed((Enum)SeedableRandomPoolConstants.LCB_EXPONENTIAL_SAMPLING_SEED));
        this.exp = new ExponentialDistribution((RandomGenerator)prng, 1.0);
    }

    protected double freeMemoryAfterGC() {
        this.log.trace("Running System Garbage Collector");
        System.gc();
        double freeMemory = (double)Runtime.getRuntime().freeMemory() / (double)Runtime.getRuntime().totalMemory();
        this.log.trace("Free memory {} %", (Object)freeMemory);
        return freeMemory;
    }

    @Override
    protected void learnModel(RunHistory runHistory, ParameterConfigurationSpace configSpace) {
        int j;
        runHistory = this.modelRunHistory;
        if (runHistory.getAlgorithmRunsExcludingRedundant().size() == 0) {
            throw new IllegalStateException("Expected one run to be done before building model");
        }
        if (this.options.randomForestOptions.subsampleValuesWhenLowMemory) {
            double freeMemory = this.freeMemoryAfterGC();
            if (freeMemory < this.options.randomForestOptions.freeMemoryPercentageToSubsample) {
                this.subsamplePercentage *= this.options.randomForestOptions.subsamplePercentage;
                Object[] args = new Object[]{this.getIteration(), freeMemory, this.subsamplePercentage};
                this.log.debug("Iteration {} : Free memory too low ({}) subsample percentage now {} ", args);
            }
        } else {
            this.subsamplePercentage = 1.0;
        }
        LinkedHashSet all_instances = new LinkedHashSet(this.instances);
        Set paramConfigs = runHistory.getUniqueParamConfigurations();
        Set runInstances = runHistory.getUniqueInstancesRan();
        ArrayList<Integer> runInstancesIdx = new ArrayList<Integer>(all_instances.size());
        int i = 0;
        double[][] instanceFeatureMatrix = new double[all_instances.size()][];
        for (Object pi : all_instances) {
            if (runInstances.contains(pi)) {
                runInstancesIdx.add(i);
            }
            instanceFeatureMatrix[i] = pi.getFeaturesDouble();
            ++i;
        }
        double[][] thetaMatrix = new double[paramConfigs.size()][];
        i = 0;
        for (ParameterConfiguration pc : paramConfigs) {
            if (this.smacConfig.mbOptions.maskInactiveConditionalParametersAsDefaultValue) {
                thetaMatrix[i++] = pc.toComparisonValueArray();
                continue;
            }
            thetaMatrix[i++] = pc.toValueArray();
        }
        int[] usedInstanceIdxs = new int[runInstancesIdx.size()];
        for (int j2 = 0; j2 < runInstancesIdx.size(); ++j2) {
            usedInstanceIdxs[j2] = (Integer)runInstancesIdx.get(j2);
        }
        List runs = runHistory.getAlgorithmRunsExcludingRedundant();
        double[] runResponseValues = RunHistoryHelper.getRunResponseValues((List)runs, (RunObjective)runHistory.getRunObjective());
        boolean[] censored = RunHistoryHelper.getCensoredEarlyFlagForRuns((List)runs);
        if (this.smacConfig.mbOptions.maskCensoredDataAsKappaMax) {
            for (j = 0; j < runResponseValues.length; ++j) {
                if (!censored[j]) continue;
                runResponseValues[j] = this.options.scenarioConfig.algoExecOptions.cutoffTime;
            }
        }
        block8: for (j = 0; j < runResponseValues.length; ++j) {
            switch (this.options.scenarioConfig.getRunObjective()) {
                case RUNTIME: {
                    if (!(runResponseValues[j] >= this.options.scenarioConfig.algoExecOptions.cutoffTime)) continue block8;
                    runResponseValues[j] = this.options.scenarioConfig.algoExecOptions.cutoffTime * this.options.scenarioConfig.getIntraInstanceObjective().getPenaltyFactor();
                    continue block8;
                }
                case QUALITY: {
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Not sure what objective this is: " + this.options.scenarioConfig.getRunObjective());
                }
            }
        }
        this.sanitizedData = new PCAModelDataSanitizer((double[][])instanceFeatureMatrix, (double[][])thetaMatrix, this.numPCA, runResponseValues, this.logModel, runHistory.getParameterConfigurationInstancesRanByIndexExcludingRedundant(), censored, configSpace);
        if (this.smacConfig.mbOptions.maskCensoredDataAsUncensored) {
            this.sanitizedData = new MaskCensoredDataAsUncensored(this.sanitizedData);
        }
        if (this.smacConfig.mbOptions.maskInactiveConditionalParametersAsDefaultValue) {
            this.sanitizedData = new MaskInactiveConditionalParametersWithDefaults(this.sanitizedData, configSpace);
        }
        this.forest = null;
        this.preparedForest = null;
        Object mb = this.options.adaptiveCapping != false ? new AdaptiveCappingModelBuilder(this.sanitizedData, this.smacConfig.randomForestOptions, this.pool.getRandom("RANDOM_FOREST_BUILDING_PRNG"), this.smacConfig.mbOptions.imputationIterations, this.smacConfig.scenarioConfig.algoExecOptions.cutoffTime, this.smacConfig.scenarioConfig.getIntraInstanceObjective().getPenaltyFactor(), this.subsamplePercentage) : new BasicModelBuilder(this.sanitizedData, this.smacConfig.randomForestOptions, this.subsamplePercentage, this.pool.getRandom("RANDOM_FOREST_BUILDING_PRNG"));
        this.forest = mb.getRandomForest();
        this.preparedForest = mb.getPreparedRandomForest();
        this.log.debug("Random Forest Built");
    }

    @Override
    protected List<ParameterConfiguration> selectConfigurations() {
        Random configSpaceRandomInterleave = this.pool.getRandom("SMAC_RANDOM_INTERLEAVED_CONFIG_PRNG");
        AutoStartStopWatch t = new AutoStartStopWatch();
        List<ParameterConfiguration> eichallengers = this.selectChallengersWithEI(this.smacConfig.numberOfChallengers);
        this.log.debug("Selecting {} challengers based on EI took {} seconds", (Object)eichallengers.size(), (Object)((double)t.stop() / 1000.0));
        ArrayList<ParameterConfiguration> randomChallengers = new ArrayList<ParameterConfiguration>(eichallengers.size());
        t = new AutoStartStopWatch();
        for (int i = 0; i < eichallengers.size(); ++i) {
            ParameterConfiguration random = this.configSpace.getRandomParameterConfiguration(configSpaceRandomInterleave);
            if (i < 25) {
                this.configTracker.addConfiguration(random, "Random-Selection-" + this.getIteration(), new String[]{"GeneratedThisRound=true"});
            }
            randomChallengers.add(random);
        }
        this.log.trace("Generating {} Random Configurations took {} seconds", (Object)eichallengers.size(), (Object)((double)t.stop() / 1000.0));
        ArrayList<ParameterConfiguration> challengers = new ArrayList<ParameterConfiguration>(eichallengers.size() * 2);
        for (int i = 0; i < eichallengers.size(); ++i) {
            challengers.add(eichallengers.get(i));
            challengers.add((ParameterConfiguration)randomChallengers.get(i));
        }
        return challengers;
    }

    public List<ParameterConfiguration> selectChallengersWithEI(int numChallengers) {
        Object meanvar;
        HashSet instanceSet = new HashSet();
        instanceSet.addAll(this.runHistory.getProblemInstancesRan(this.incumbent));
        double[][] tmp_predictions = ArrayMathOps.transpose((double[][])this.applyMarginalModel(Collections.singletonList(this.incumbent)));
        this.log.trace("Prediction for incumbent: {} +/- {} (in log space if logModel=true)", (Object)tmp_predictions[0][0], (Object)tmp_predictions[1][0]);
        double fmin = this.runHistory.getEmpiricalCost(this.incumbent, instanceSet, this.smacConfig.scenarioConfig.algoExecOptions.cutoffTime);
        double lcbStandardErrors = this.exp.sample();
        if (this.smacConfig.randomForestOptions.logModel.booleanValue()) {
            fmin = Math.max(0.005, fmin);
            fmin = Math.log10(fmin);
            double adjusted_fmin = this.runHistory.getEmpiricalCost(this.incumbent, instanceSet, this.smacConfig.scenarioConfig.algoExecOptions.cutoffTime, 0.005);
            adjusted_fmin = Math.max(0.005, adjusted_fmin);
            adjusted_fmin = Math.log10(adjusted_fmin);
            Object[] args = new Object[]{this.getIteration(), fmin, adjusted_fmin};
            this.log.trace("Optimizing EI at valdata.iteration {}. fmin: {}, fmin (accounting for minimum response value): {}", args);
        } else {
            this.log.debug("Optimizing EI at valdata.iteration {}. fmin: {}", (Object)this.getIteration(), (Object)fmin);
        }
        List paramConfigs = this.runHistory.getAllParameterConfigurationsRan();
        Random rand = this.pool.getRandom("SMAC_RANDOM_EI_LOCAL_SEARCH");
        HashSet<ParameterConfiguration> randomParameterConfigurations = new HashSet<ParameterConfiguration>();
        for (int i = 0; i < this.options.numberOfRandomConfigsUsedForLocalSearch; ++i) {
            randomParameterConfigurations.add(this.configSpace.getRandomParameterConfiguration(rand));
        }
        randomParameterConfigurations.removeAll(paramConfigs);
        paramConfigs.addAll(randomParameterConfigurations);
        double[][] predictions = ArrayMathOps.transpose((double[][])this.applyMarginalModel(paramConfigs));
        double[] predmean = predictions[0];
        double[] predvar = predictions[1];
        AutoStartStopWatch watch = new AutoStartStopWatch();
        double[] negativeExpectedImprovementOfTheta = this.ei.computeAcquisitionFunctionValue(fmin, predmean, predvar, lcbStandardErrors);
        watch.stop();
        this.log.debug("Compute negEI for all conf. seen at valdata.iteration {}: took {} s", (Object)this.getIteration(), (Object)((double)watch.time() / 1000.0));
        LinkedHashMap<Object, Object> configPredMeanVarEIMap = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < paramConfigs.size(); ++i) {
            double[] val = new double[]{predmean[i], predvar[i], negativeExpectedImprovementOfTheta[i]};
            configPredMeanVarEIMap.put(paramConfigs.get(i), val);
        }
        List sortedParams = ParamWithEI.merge((double[])negativeExpectedImprovementOfTheta, (List)paramConfigs);
        Collections.sort(sortedParams);
        int numberOfSearches = Math.min(numChallengers, predmean.length);
        List bestResults = new ArrayList<ParamWithEI>(numberOfSearches);
        double min_neg = Double.MAX_VALUE;
        AutoStartStopWatch stpWatch = new AutoStartStopWatch();
        HashSet<Object> selectedByRandomStartPoint = new HashSet<Object>();
        for (int i = 0; i < numberOfSearches; ++i) {
            watch = new AutoStartStopWatch();
            ParamWithEI lsResult = this.localSearch((ParamWithEI)sortedParams.get(i), fmin, Math.pow(10.0, -5.0), lcbStandardErrors);
            if ((Double)lsResult.getAssociatedValue() < min_neg) {
                min_neg = (Double)lsResult.getAssociatedValue();
            }
            predictions = ArrayMathOps.transpose((double[][])this.applyMarginalModel(Collections.singletonList(lsResult.getValue())));
            Object val = new double[]{predictions[0][0], predictions[1][0], (Double)lsResult.getAssociatedValue()};
            bestResults.add(lsResult);
            configPredMeanVarEIMap.put(lsResult.getValue(), val);
            watch.stop();
            Object[] args = new Object[]{i + 1, (double)watch.time() / 1000.0, min_neg};
            this.log.trace("LS {} took {} seconds and yielded neg log EI {}", args);
            if (!randomParameterConfigurations.contains(sortedParams.get(i))) continue;
            selectedByRandomStartPoint.add(lsResult.getValue());
        }
        this.log.trace("{} Local Searches took {} seconds in total ", (Object)numberOfSearches, (Object)((double)stpWatch.stop() / 1000.0));
        double[][] configArrayToDebug = new double[bestResults.size()][];
        int j = 0;
        for (ParamWithEI bestResult : bestResults) {
            configArrayToDebug[j++] = ((ParameterConfiguration)bestResult.getValue()).toValueArray();
        }
        int numberOfRandomConfigsInEI = this.smacConfig.numberOfRandomConfigsInEI;
        Random configSpaceEIRandom = this.pool.getRandom("SMAC_RANDOM_EI_CONFIG_PRNG");
        AutoStartStopWatch t = new AutoStartStopWatch();
        ArrayList<ParameterConfiguration> randomConfigs = new ArrayList<ParameterConfiguration>(numberOfRandomConfigsInEI);
        for (int i = 0; i < numberOfRandomConfigsInEI; ++i) {
            randomConfigs.add(this.configSpace.getRandomParameterConfiguration(configSpaceEIRandom));
        }
        if (randomConfigs.size() > 0) {
            this.log.trace("Generating {} Random Configurations for EI took {} (s)", (Object)numberOfRandomConfigsInEI, (Object)((double)t.stop() / 1000.0));
            t = new AutoStartStopWatch();
            double[][] randomConfigToDebug = new double[randomConfigs.size()][];
            for (int i = 0; i < randomConfigs.size(); ++i) {
                randomConfigToDebug[i] = ((ParameterConfiguration)randomConfigs.get(i)).toValueArray();
            }
            predictions = ArrayMathOps.transpose((double[][])this.applyMarginalModel(randomConfigs));
            predmean = predictions[0];
            predvar = predictions[1];
            this.log.trace("Prediction for Random Configurations took {} (s)", (Object)((double)t.stop() / 1000.0));
            t = new AutoStartStopWatch();
            double[] expectedImprovementOfRandoms = this.ei.computeAcquisitionFunctionValue(fmin, predmean, predvar, lcbStandardErrors);
            this.log.trace("EI Calculation for Random Configurations took {} (s)", (Object)((double)t.stop() / 1000.0));
            t = new AutoStartStopWatch();
            for (int i = 0; i < randomConfigs.size(); ++i) {
                double[] val = new double[]{predmean[i], predvar[i], expectedImprovementOfRandoms[i]};
                configPredMeanVarEIMap.put(randomConfigs.get(i), val);
            }
            this.log.trace("Map Insertion for Random Configurations took {} (s)", (Object)((double)t.stop() / 1000.0));
            bestResults.addAll(ParamWithEI.merge((double[])expectedImprovementOfRandoms, randomConfigs));
        }
        configArrayToDebug = new double[bestResults.size()][];
        j = 0;
        for (ParamWithEI eic : bestResults) {
            configArrayToDebug[j++] = ((ParameterConfiguration)eic.getValue()).toValueArray();
        }
        bestResults = ArrayMathOps.permute(bestResults, (Random)configSpaceEIRandom);
        Collections.sort(bestResults);
        for (int i = 0; i < numberOfSearches; ++i) {
            meanvar = (double[])configPredMeanVarEIMap.get(((ParamWithEI)bestResults.get(i)).getValue());
            Object[] args = new Object[]{i + 1, (double)meanvar[0], Math.sqrt((double)meanvar[1]), (double)(-meanvar[2])};
            this.log.trace("Challenger {} predicted {} +/- {}, expected improvement {}", args);
        }
        ArrayList<Object> results = new ArrayList<Object>(bestResults.size());
        meanvar = bestResults.iterator();
        while (meanvar.hasNext()) {
            ParamWithEI eic = (ParamWithEI)meanvar.next();
            results.add(eic.getValue());
        }
        for (int i = 0; i < Math.min(25, bestResults.size()); ++i) {
            ParamWithEI eic = (ParamWithEI)bestResults.get(i);
            this.configTracker.addConfiguration((ParameterConfiguration)eic.getValue(), "Model-Builder-" + this.getIteration(), new String[]{"EIMethod=" + this.options.expFunc, "EI=" + eic.getAssociatedValue(), "firstArg(k)=" + fmin, "ModelVersion=" + this.getIteration(), "ModelPoints=" + this.runHistory.getAlgorithmRunsExcludingRedundant().size()});
        }
        if (randomParameterConfigurations.contains(((ParamWithEI)bestResults.get(0)).getValue())) {
            this.log.warn("Best result was local search from a random configuration: " + ((ParameterConfiguration)((ParamWithEI)bestResults.get(0)).getValue()).getFormattedParameterString());
        }
        return Collections.unmodifiableList(results);
    }

    private ParamWithEI localSearch(ParamWithEI startEIC, double fmin_sample, double epsilon, double lcbStandardErrors) {
        ParamWithEI incumbentEIC = startEIC;
        int localSearchSteps = 0;
        Random configRandLS = this.pool.getRandom("SMAC_EI_LOCAL_SEARCH_NEIGHBOURS");
        while (true) {
            if (++localSearchSteps % 1000 == 0) {
                this.log.warn("Local Search has done {} iterations, possible infinite loop", (Object)localSearchSteps);
            }
            ParameterConfiguration c = (ParameterConfiguration)incumbentEIC.getValue();
            double currentMinEI = (Double)incumbentEIC.getAssociatedValue();
            double[][] cArray = new double[][]{c.toValueArray()};
            int LSHashCode = ArrayMathOps.matlabHashCode((double[][])cArray);
            List neighbourhood = c.getNeighbourhood(configRandLS, this.options.scenarioConfig.algoExecOptions.paramFileDelegate.continuousNeighbours);
            double[][] prediction = ArrayMathOps.transpose((double[][])this.applyMarginalModel(neighbourhood));
            double[] means = prediction[0];
            double[] vars = prediction[1];
            double[] eiVal = this.ei.computeAcquisitionFunctionValue(fmin_sample, means, vars, lcbStandardErrors);
            double min = eiVal[0];
            for (int i = 1; i < eiVal.length; ++i) {
                if (!(eiVal[i] < min)) continue;
                min = eiVal[i];
            }
            if (min >= currentMinEI - epsilon) break;
            ArrayList<Integer> minIdx = new ArrayList<Integer>(c.size());
            for (int i = 0; i < eiVal.length; ++i) {
                if (!(eiVal[i] <= min + epsilon)) continue;
                minIdx.add(i);
            }
            if (minIdx.size() == 0) {
                throw new IllegalStateException("AAAAAAH!");
            }
            int nextIdx = (Integer)minIdx.get(configRandLS.nextInt(minIdx.size()));
            ParameterConfiguration best = (ParameterConfiguration)neighbourhood.get(nextIdx);
            incumbentEIC = new ParamWithEI(Double.valueOf(eiVal[nextIdx]), best);
            double[][] next = new double[][]{best.toValueArray()};
            double[][] predictions = ArrayMathOps.transpose((double[][])this.applyMarginalModel(next));
            double[] mean = predictions[0];
            double[] var = predictions[1];
            eiVal = this.ei.computeAcquisitionFunctionValue(fmin_sample, mean, var, lcbStandardErrors);
        }
        this.log.trace("Local Search took {} steps", (Object)localSearchSteps);
        return incumbentEIC;
    }

    protected double[][] applyMarginalModel(double[][] configArrays) {
        int[] treeIdxsToUse = new int[this.forest.numTrees];
        for (int i = 0; i < this.forest.numTrees; ++i) {
            treeIdxsToUse[i] = i;
        }
        if (this.smacConfig.randomForestOptions.preprocessMarginal) {
            return RandomForest.applyMarginal((RandomForest)this.preparedForest, (int[])treeIdxsToUse, (double[][])configArrays);
        }
        return RandomForest.applyMarginal((RandomForest)this.forest, (int[])treeIdxsToUse, (double[][])configArrays, (double[][])this.sanitizedData.getPCAFeatures());
    }

    protected double[][] applyMarginalModel(List<ParameterConfiguration> configs) {
        double[][] configArrays = new double[configs.size()][];
        int i = 0;
        for (ParameterConfiguration config : configs) {
            configArrays[i] = config.toValueArray();
            ++i;
        }
        return this.applyMarginalModel(configArrays);
    }

    @Override
    protected Object getModel() {
        return this.preparedForest;
    }
}

