public class Atom extends Vertex{

    private int AtomID;
    private char ChainID;
    private String Element;
    private String Residue;
    private boolean Interacts;
    
    public Atom() {
	super();
	Interacts = false;
    }
    
    public Atom(int AtomID, char ChainID, String Element, String Residue, double x, double y, double z) {
	super(x,y,z);
	this.AtomID = AtomID;
	this.ChainID = ChainID;
	this.Element = Element;
	this.Residue = Residue;
	Interacts = false;
    }
    
    public Atom(int AtomID, char ChainID, String Element, String Residue, Vertex vertex) {
	super(vertex.x,vertex.y,vertex.z);
	this.AtomID = AtomID;
	this.ChainID = ChainID;
	this.Element = Element;
	this.Residue = Residue;
	Interacts = false;
    }
    
    public Atom(double x, double y, double z) {
	super(x,y,z);
	Interacts = false;
    }
    
    public int getAtomID(){
	return AtomID;
    }
    
    public char getChainID(){
	return ChainID;
    }
    
    public String getElement(){
	return Element;
    }

    public String getResidue() {
	return Residue;
    }
 
    public void setInteraction(boolean Interacts){
	this.Interacts = Interacts;
    }

    public boolean getInteraction(){
	return Interacts;
    }

    public boolean isCarbonAlfa(){
	if(getElement().equals(new String("CA")))
	    return true;
	else
	    return false;
    }

    public boolean isNitrogen(){
	if(getElement().equals(new String("N")))
	    return true;
	else
	    return false;
    }

    public boolean isBackbone() {
	if(getElement().equals(new String("CA")) || getElement().equals(new String("N"))  || getElement().equals(new String("C")) || getElement().equals(new String("O")) )
	    return true;
	else
	    return false;
    }

    public boolean isSideChain() {
	return !isBackbone();
    }

    public String toString() {
	return ("("+AtomID+","+ChainID+","+Element+","+Residue+","+super.x+","+super.y+","+super.z+")");
    }
}
