import Jama.*;
import java.io.*;

public class PCA {
    
    private Domain DA;
    private Domain DB;
    private Matrix VarCov;
    private Matrix D;
    private Matrix V;
    private Vertex C[];
    private double[] x,y,z;
    private int size,sizeA,sizeB;
    
    public PCA(Domain DA, Domain DB) {
	Object[] A,B;
	this.DA = DA;
	this.DB = DB;
	sizeA=DA.getNoAtoms();
	sizeB=DB.getNoAtoms();
	A=DA.getAtomsArray();
	B=DB.getAtomsArray();
	size = sizeA + sizeB;
	C = new Vertex[size];
	for (int i=0;i<size;i++){
	    if(i<sizeA)
		C[i]=(Vertex)A[i];
	    else
		C[i]=(Vertex)B[i-sizeA];
	}
	setCoord();
	pcaTransform();
	//print2File();
    }
    
    public Matrix getVarCov(){
	return VarCov;
    }
    
    public Matrix getEigVect(){
	return V;
    }
    
    public Matrix getEigVal(){
	return D;
    }
    
    private void pcaTransform(){
	setVarCov();
	EigenvalueDecomposition E = new EigenvalueDecomposition(VarCov);
	V = E.getV();
	D = E.getD();
	V = V.transpose();
	rotateData();
	flash();
    }

    private void flash(){
	Object[] A,B;
	A=DA.getAtomsArray();
	B=DB.getAtomsArray();
	for (int i=0;i<size;i++)
	    if(i<sizeA)
		A[i]=C[i];
	    else
		B[i-sizeA]=C[i];
    }

    private void rotateData(){
	double[][] eig = V.getArray();
	for(int i=0;i<size;i++){
	    C[i].x=eig[0][0]*x[i]+eig[0][1]*y[i]+eig[0][2]*z[i];
	    C[i].y=eig[1][0]*x[i]+eig[1][1]*y[i]+eig[1][2]*z[i];
	    C[i].z=eig[2][0]*x[i]+eig[2][1]*y[i]+eig[2][2]*z[i];
	}
    }

    private void setVarCov(){
	double[][] CovMatr = new double[3][3];
	CovMatr[0][0]=sq_mean(x)-Math.pow(mean(x),2.0);
	CovMatr[1][1]=sq_mean(y)-Math.pow(mean(y),2.0);
	CovMatr[2][2]=sq_mean(z)-Math.pow(mean(z),2.0);
	CovMatr[0][1]=CovMatr[1][0]=cov(x,y)-mean(x)*mean(y);
	CovMatr[0][2]=CovMatr[2][0]=cov(x,z)-mean(x)*mean(z);
	CovMatr[1][2]=CovMatr[2][1]=cov(y,z)-mean(y)*mean(z);
	VarCov = new Matrix(CovMatr);
    }

    private double cov(double[] x,double[] y){
	double cov = 0;
	for(int i=0;i<size;i++)
	    cov+=x[i]*y[i];
	return cov/size;
    }

    private double sq_mean(double[] x){
	double sq_sum = 0;
	for(int i=0;i<size;i++)
	    sq_sum+=Math.pow(x[i],2.0);
	return sq_sum/size;
    }
    
    private double mean(double[] x){
	double sum = 0;
	for(int i=0;i<size;i++)
	    sum+=x[i];
	return sum/size;
    }
    
    private void setCoord(){
	x = new double[size];
	y = new double[size];
	z = new double[size];
	for(int i=0;i<size;i++){
	    x[i]=C[i].x;
	    y[i]=C[i].y;
	    z[i]=C[i].z;
	}
    }
    
    private void print2File(){
	try{
	PrintWriter fileOut = new PrintWriter(new FileWriter("PCA.txt"));
	fileOut.println("List of X Y Z Coordinates:");
	for (int i=0;i<size;i++)
	      fileOut.println(C[i].toString());
	fileOut.close();
	}catch(IOException e){System.out.println(e);}
    }
}
