/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;

class NIOControlPacket
extends NIOPacket {
    short nsControlCommand;
    static final short NSPCTL_SERR = 8;
    static final int ORA_ERROR_EMFI_NUMBER = 22;

    NIOControlPacket(SessionAtts sessionAtts) {
        super(sessionAtts);
        this.header.type = 10;
    }

    @Override
    void readPayloadBuffer() throws IOException {
        this.nsControlCommand = this.session.payloadBuffer.getShort();
        if (this.nsControlCommand == 8) {
            this.processNSError();
        }
    }

    void processNSError() throws IOException {
        int n2 = this.session.payloadBuffer.getInt();
        int n3 = this.session.payloadBuffer.getInt();
        int n4 = this.session.payloadBuffer.getInt();
        if (n2 == 22) {
            throw new NetException(n3, "ORA-" + n3, true);
        }
        throw new NetException(n3, "TNS-" + n3, true);
    }
}

