// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Example to demonstrate the use of Rendezvous() with threads 
//

#include "CommonFramework.h"
#include <e32math.h>

//
// Common literal text
//


_LIT(KMsgMyThreadName, "MyThread");
_LIT(KMsgStartThread, "Start thread\n");
_LIT(KMsgThreadRendezvousReached,"Thread rendezvous reached\n");
_LIT(KMsgEndOfTest,"End of test\n");
_LIT(KMsgSomethingIsWrong, "Something is wrong\n");
_LIT(KMsgCreateThreadFailed, "Create thread failed\n");

//Define
const TInt KHeapSize = 0x2000;

//************************************************************
// Declare Thread functions
//************************************************************
TInt MyThread(TAny* aParameter)
	{
		// simulate some processing
	User::After((TInt)aParameter);		
			
			// signal Rendezvous
	RThread::Rendezvous(KErrNone);
	
		// simulate some processing
	User::After((TInt)aParameter);		
	
	return(KErrNone);
	}

//************************************************************
// Main example code function
//************************************************************
LOCAL_C void doExampleL()
	{				  
		// create threads to wait for
	RThread thread;

		// indicate completion status
	TRequestStatus myThreadRendezvousStatus;

		// pass 500 as the parameter to MyThread		
	TInt r=thread.Create(KMsgMyThreadName, MyThread, KDefaultStackSize, KHeapSize,KHeapSize,(TAny*) 2000000, EOwnerThread);	
	if (r!=KErrNone)
		{	
	 	console->Printf(KMsgCreateThreadFailed);
		return;
		}
		// create rendezvous
	thread.Rendezvous(myThreadRendezvousStatus);

		//EXCECUTE THREAD!
	console->Printf(KMsgStartThread);					
	thread.Resume();

	User::WaitForRequest(myThreadRendezvousStatus);
	if(myThreadRendezvousStatus==KErrNone)
		{
		console->Printf(KMsgThreadRendezvousReached);
		}
		else
		{
		console->Printf(KMsgSomethingIsWrong);	
		}	
		
	thread.Close();
	console->Printf(KMsgEndOfTest);		
	
	}


 	



	
	
