// PngConvert.H
//
// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//
//

#ifndef __PNGCONVERT_H__
#define __PNGCONVERT_H__

#include <icl/imageplugin.h>

#include "PNGCodec.h"

//
// PNG decoder class
//
class CPngDecoder : public CImageDecoderPlugin
	{
public:
	// Construction
 	static CPngDecoder* NewL();
	~CPngDecoder();

private:
	// from CImageDecoderPlugin
	
	// Gets the image type and sub-type for a given frame of the image that
	// has just been decoded.
	virtual void ImageType(TInt aFrameNumber, TUid& aImageType, TUid& aImageSubType) const;	
	// Gets text descriptions of image properties
	CFrameInfoStrings* FrameInfoStringsL(RFs& aFs, TInt aFrameNumber);
	// Scans the image header.
	void ScanDataL();

private:
	CPngDecoder();
	void ReadFormatL();
	};

//
// PNG encoder class
//
class CPngEncoder : public CImageEncoderPlugin
	{
public:
	// Construction
	static CPngEncoder* NewL();
	 ~CPngEncoder();

private:
	// from CImageEncoderPlugin

	// Sets up the codec to encode the frame
	void PrepareEncoderL(const CFrameImageData* aFrameImageData);
	// Update header (not used)
	void UpdateHeaderL() {};

private:
	CPngEncoder();
	};

#endif // __PNGCONVERT_H__
