// PNGProxy.cpp
//
// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//
//

// Supplies the factory function called by ECom, and factories for
// the PNG decoder and encoder

// Ecom headers
#include <ecom.h>
#include <implementationproxy.h>

// ICL base class
#include <icl/imageconstruct.h>

#include "uids.h"
#include "PNGCodec.h"


//
// Factory for PNG decoder
//
class CPngDecodeConstruct : public CImageDecodeConstruct
	{
public:
	// Constructs the factory
	static CPngDecodeConstruct* NewL();

	// Supplies a new decoder
	// from CImageDecodeConstruct
	CImageDecoderPlugin* NewPluginL() const;
	};

CPngDecodeConstruct* CPngDecodeConstruct::NewL()
	{
	CPngDecodeConstruct* self = new (ELeave) CPngDecodeConstruct;
	return self;
	}

CImageDecoderPlugin* CPngDecodeConstruct::NewPluginL() const
	{
	return CPngDecoder::NewL();
	}


//
// Factory for PNG encoder
//
class CPngEncodeConstruct : public CImageEncodeConstruct
	{
public:
	// Constructs the factory
	static CPngEncodeConstruct* NewL();

	// Supplies a new encoder
	// from CImageEncodeConstruct
	CImageEncoderPlugin* NewPluginL() const;
	};

CPngEncodeConstruct* CPngEncodeConstruct::NewL()
	{
	CPngEncodeConstruct* self = new (ELeave) CPngEncodeConstruct;
	return self;
	}

CImageEncoderPlugin* CPngEncodeConstruct::NewPluginL() const
	{
	return CPngEncoder::NewL();
	}



//
// Exported proxy for ECom instantiation method resolution
//

// Define the factories for the PNG converters
const TImplementationProxy ImplementationTable[] =
	{
		IMPLEMENTATION_PROXY_ENTRY(KExPNGDecoderImplementationUidValue, CPngDecodeConstruct::NewL),
		IMPLEMENTATION_PROXY_ENTRY(KExPNGEncoderImplementationUidValue, CPngEncodeConstruct::NewL)
	};

EXPORT_C const TImplementationProxy* ImplementationGroupProxy(TInt& aTableCount)
	{
	aTableCount = sizeof(ImplementationTable) / sizeof(TImplementationProxy);
	return ImplementationTable;
	}

//
// Global panic function
//
GLDEF_C void Panic(TInt aError)
	{
	_LIT(KPNGPanicCategory, "PNGExConvertPlugin");
	User::Panic(KPNGPanicCategory, aError);
	}

