// Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//


#if !defined(__WSPRIT11_H__)
#define __WSPRIT11_H__

#include "Base.h"

// CMainWindow is a plain window that just acts as a container for the
// other windows
class CMainWindow : public CWindow
	{
public:
	CMainWindow (CWsClient* aClient);
	~CMainWindow ();
	void Draw (const TRect& aRect);
	void HandlePointerEvent (TPointerEvent& aPointerEvent);
	void HandlePointerMoveBufferReady ();
	};

//////////////////////////////////////////////////////////////////////////
//						Derived client class
//////////////////////////////////////////////////////////////////////////

class CSprite;

class CExampleWsClient : public CWsClient
	{
public:
	static CExampleWsClient* NewL(const TRect& aRect);
private:
	CExampleWsClient (const TRect& aRect);
	void ConstructMainWindowL();
	~CExampleWsClient ();
	void RunL ();
	void HandleKeyEventL (TKeyEvent& aKeyEvent);
private:
	CMainWindow*	iMainWindow;
	CSprite*		iSprite;
	const TRect& iRect;
	};

class CSprite : public CBase
	{
public:
	CSprite (CWsClient* aClient);
	~CSprite ();
	void ConstructL(CWindow* aWindow);
	void CreateBitmapL(CFbsBitmap* &aBitmap, TInt aSpriteNum, TBool aDoMask);
private:
	CWsClient*	iClient;
	RWsSprite	iSprite;
	TSpriteMember	iSpriteMember[4];
	};

#endif
