// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the definition of the CDatabase class.
//
#ifndef CDATABASE_H_
#define CDATABASE_H_

#include <e32cons.h>
#include <e32base.h>  //Used for CBase.
#include <d32dbms.h>  //Used for RDbDatabase class.
#include <s32file.h>  //Used for CFileStore class.

/**
This is a database class which is used by two different threads to demonstrate thread
synchronization using a semaphore. 
*/
class CDatabase : public CBase
{
public:
    static CDatabase* NewL();
    virtual ~CDatabase();
    
    //Method to create a database.
    void CreateDatabaseL();
    //Method to read the database. 
    void ReadfromDatabaseL();
    //Method to write into the database.
    void WritetoDatabaseL();
    
    //The callback function for ReaderThread associated with the CPeriodic object.
    static TInt PeriodicReadL(TAny* aPtr);
    //The periodic function to read the database. 
    void PeriodicReadFuncL();
    
    //The callback function for WriterThread associated with the CPeriodic object.
    static TInt PeriodicWriteL(TAny* aPtr);
    //The periodic function to write into the database.
    void PeriodicWriteFuncL();

protected: 
    void ConstructL();

private: 
    RFs iFsSession; //file session object.
    RDbStoreDatabase iDatabase; //database object.
    TFileName iDbname;
    
    //CPeriodic object to periodically read/write to the DB.
    CPeriodic* iPeriodic; 
    
    CConsoleBase* iConsole; 
    
    #ifdef USE_SEMAPHORE
    //Semaphore which schedules order of execution.  
    RSemaphore iSemWrite; 
    #endif
};

#endif /*CDATABASE_H_*/
