/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef __DBMSEDITORVIEW_H__
#define __DBMSEDITORVIEW_H__


#include <coecntrl.h>
#include <aknsettingitemlist.h> 

/**
 * Class:       CDBMSEditorView
 *
 * Description: An instance of this class is the Application View object for
 *              the DBMS example application.
 *
 *              This is window owning container control. It shows three
 *              editboxes, where user can give in DBMS properties.
 */
class CDBMSEditorView: public CCoeControl
    {

public:

    /**
     * Function:    NewL
     *
     * Description: Create a CDBMSEditorView object, which will draw
     *              itself to aRect.
     *
     * Param:       aRect the rectangle this view will be drawn to
     *
     * Returns:     A pointer to the created instance of CDBMSEditorView
     */
    static CDBMSEditorView* NewL(const TRect& aRect);

    /**
     * Function:    ~CDBMSEditorView
     * Description: Destroy the object
     */
     ~CDBMSEditorView();

public:  // For the use of CDBMSAppUi

    /**
     * Function:    GetAuthor
     *
     * Description: Returns author in the iEdwinAuthor editor field.
     *              Provide long enough descriptor.
     */
    void GetAuthorL(TDes& aResult) const;

    /**
     * Function:    GetTitle
     *
     * Description: Returns DBMS title in the iEdwinTitle editor field.
     *              Provide long enough descriptor.
     */
    void GetTitleL(TDes& aResult) const;

    /**
     * Function:    GetDescription
     *
     * Description: Returns DBMS description in the iEdwinDescription
     *              editor field. Provide long enough descriptor.
     */
    void GetDescriptionL(TDes& aResult) const;

private: // Construction

    /**
     * Function:    ConstructL
     *
     * Description: Perform the second phase construction of a
     *              CDBMSEditorView object.
     *
     * Param:       aRect the rectangle this view will be drawn to
     */
    void ConstructL(const TRect& aRect);

    /**
     * Function:   CDBMSEditorView
     *
     * Description: Perform the first phase of two phase construction.
     */
    CDBMSEditorView();


	/**
	* Loads the list dynamically.
	*/	
	void LoadListL();
	
	/**
	* Stores the settings of the setting list.
	*/	
    void StoreSettingsL();
    
private: // from CCoeControl

    /**
     * Function:     CountComponentControls
     *
     * Returns:      Number of controls within this container.
     */
    TInt CountComponentControls() const;

    /**
     * Function:     ComponentControl
     *
     * Param:        aIndex of control
     *
     * Returns:      One of the controls this class owns.
     */
    CCoeControl* ComponentControl(TInt aIndex) const;

    /**
     * Function:     Draw
     *
     * Description:  Paints this container control (but not
     *               the controls within this container).
     *
     * Param:        aRect Frame rectangle for container.
     */
    void Draw(const TRect& aRect) const;

    /**
     * Function:     OfferKeyEventL
     *
     * Description:  Handles key events for this control. Mostly forwards
     *               them to contained controls (editor controls)
     *
     * Param:        aKeyEvent The key event.
     *
     * Param:        aType The type of the event.
     *
     * Returns:      Indicates whether or not the key event was
     *               used (consumed) by this control.
     */
    TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent,
                                TEventCode aType);
                                
	/**
     * From CoeControl, HandleResourceChange.
     * Called by framework when the view layout is changed.
     */
    virtual void HandleResourceChange(TInt aType);

    
private:

	CAknSettingItemList* iItemList;
	CAknTextSettingItem* iAuthor;
	CAknTextSettingItem* iTitle;
	CAknTextSettingItem* iDescription;

    };

#endif // __DBMSEDITORVIEW_H__
