/*
 * Copyright  2008 Nokia Corporation.
 */

#include <eikenv.h>
#include <gdi.h>
#include <AknUtils.h>

#include "DBMSAppView.h"

// ---------------------------------------------------------------------------
// CDBMSAppUi::NewL()
//
// Create instance of this view.
// ---------------------------------------------------------------------------
CDBMSAppView* CDBMSAppView::NewL(const TRect& aRect)
    {
    CDBMSAppView* self = new (ELeave) CDBMSAppView;
    CleanupStack::PushL(self);
    self->ConstructL(aRect);
    CleanupStack::Pop(self);
    return self;
    }

// ---------------------------------------------------------------------------
// CDBMSAppUi::ConstructL()
//
// Perform the second phase construction.
// ---------------------------------------------------------------------------
void CDBMSAppView::ConstructL(const TRect& aRect)
    {
    // Create a window for this application view
    CreateWindowL();

    // Set the windows size
    SetRect(aRect);

    ActivateL();
    }

// ---------------------------------------------------------------------------
// CDBMSAppUi::CDBMSAppView()
//
// Constructor
// ---------------------------------------------------------------------------
CDBMSAppView::CDBMSAppView()
    {
    // No implementation required
    }


// ---------------------------------------------------------------------------
// CDBMSAppUi::~CDBMSAppView()
//
// Desctructor
// ---------------------------------------------------------------------------
CDBMSAppView::~CDBMSAppView()
    {
    }

// ---------------------------------------------------------------------------
// CDBMSAppUi::Draw()
//
// Draw the view. Show simple "DBMS" text in the center of the view.
// This is called by the framework, when necessary.
// ---------------------------------------------------------------------------
void CDBMSAppView::Draw(const TRect& /*aRect*/) const
    {
    _LIT(KText,"DBMS");

    CWindowGc& gc = SystemGc(); // Window graphics context
    TRect drawRect = Rect();    // Area in which we shall draw
    const CFont* fontUsed = iEikonEnv->TitleFont();
    gc.Clear();                 // Start with a clear screen

    // Draw an outline rectangle slightly smaller than the drawing area.
    drawRect.Shrink(10,10);
    gc.DrawRect(drawRect);
    gc.UseFont(fontUsed);
               // Draw the text in the middle of the rectangle.
    TInt baselineOffset=(drawRect.Height() - fontUsed->HeightInPixels())/2;
    gc.DrawText(KText, drawRect, baselineOffset, CGraphicsContext::ECenter, 0);
               // Finished using the font
    gc.DiscardFont();
    }


