// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the definition of the CMyStringReverse class.
//



/**
 @file
*/
#ifndef __MYSTRINGREVERSE_H__
#define __MYSTRINGREVERSE_H__

#include "letter.h"

/**
This class has the doubly linked list, iString.
This string represents the user-entered string.
The member functions of this class allow users to edit the string
and get a reverse string of this string.
*/
class CMyStringReverse : public CActive
	{
private:
	/**
	This enumeration defines the tasks for different key-press events.
	*/
	enum TTask 	{
				ETaskNone,
				/**
				Call the TDblQue::AddFirst() function on iString.
				*/
				ETaskStringAddFirst,
				/**
				Call the TDblQue::AddLast() function on iString.
				*/
				ETaskStringAddLast
				};
public:
	static CMyStringReverse* NewL(CConsoleBase* aConsole);
	void RunL();
	void DoCancel();
	void AddToScheduler();
	~CMyStringReverse();
	void ReadOption();
	void ReadChar();
	void PrintStrings();	
private:
	CMyStringReverse(CConsoleBase* aConsole);
	void ReadFunc();
private:
	/**
	This doubly linked list stores the string entered by the user.
	*/
	TDblQue<TLetter> iString;
	/**
	The iterator for iString.
	*/
	TDblQueIter<TLetter> iIteratorString;
	/**
	The user console.
	*/
	CConsoleBase* iConsole;
	/**
	The task to be done by the RunL() method of the active object.
	@see CMyStringReverse::Task.
	*/
	TTask iTask;	
	};

#endif

