// Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//


#include <e32base.h>
#include <e32cons.h>
#include "rconnection.h"


_LIT(KRow01,"*****************************************\n");
_LIT(KRow02,"*     Welcome to RConnection Example    *\n");
_LIT(KRow03,"*****************************************\n");
_LIT(KRow04,"Press a Key to step through the Example\n");
_LIT(KNewLine,"\n");

static void DoStartL(CConsoleBase* aConsole); 
static void WelcomeScreen(CConsoleBase* aConsole);
static void CallExampleL(); // initialize with cleanup stack, then do example

static void DoStartL(CConsoleBase* aConsole)
	{
	// Create active scheduler (to run active objects).
	CActiveScheduler* scheduler = new (ELeave) CActiveScheduler();
	CleanupStack::PushL(scheduler);
	CActiveScheduler::Install(scheduler);

	CRConnection* example = new (ELeave) CRConnection(aConsole);
	CleanupStack::PushL(example);
	
	WelcomeScreen(aConsole);
	
	example->DemoApiWithoutDbOverrideL();	
	
	example->DemoApiWithDbOverrideL();
	
	example->AttachToExistingInterfaceL();
	
	CleanupStack::PopAndDestroy(example);

	// Delete active scheduler.
	CleanupStack::PopAndDestroy(scheduler);	
	}

static void CallExampleL() // initialize and call example code under cleanup stack
    {
    _LIT(KTxtExampleCode,"Symbian platform Example Code");
    _LIT(KFormatFailed,"failed: leave code=%d");
    _LIT(KTxtOK,"ok");
    _LIT(KTxtPressAnyKey," [press any key to exit]");
    
	CConsoleBase* console=Console::NewL(KTxtExampleCode,TSize(KConsFullScreen,KConsFullScreen));
	CleanupStack::PushL(console);
	
	TRAPD(error,DoStartL(console)); // perform example
	
	if (error)
		console->Printf(KFormatFailed, error);
	else
		console->Printf(KTxtOK);
	
	console->Printf(KTxtPressAnyKey);
	console->Getch(); // get and ignore character
	
	CleanupStack::PopAndDestroy(); // close console
    }

extern TInt E32Main() // main function called by E32
    {
    _LIT(KEgPanicCat,"EXAMPLES");
	__UHEAP_MARK;
	CTrapCleanup* cleanup=CTrapCleanup::New(); // create clean-up stack
	TRAPD(error,CallExampleL()); // do example
	__ASSERT_ALWAYS(!error,User::Panic(KEgPanicCat,error));
	delete cleanup; // destroy clean-up stack
	__UHEAP_MARKEND;
	return 0; // and return
    }

//Display for welcome screen.
static void WelcomeScreen(CConsoleBase* aConsole)
	{
	aConsole->ClearScreen();
	aConsole->Printf(KRow01);
	aConsole->Printf(KRow02);
	aConsole->Printf(KRow03);
	aConsole->Printf(KNewLine);
	aConsole->Printf(KRow04);
	aConsole->Getch();	
	}

