// TXCLIENT.CPP
//
//  2004 Nokia Corporation.  All rights reserved.
//

// class include
#include "txclient.h"

// system includes
#include <e32std.h>
#include <txtrich.h>
#include <msvids.h>	        // KMsvLocalServiceIndexEntryId
#include <msvreg.h>	
#include <msvstore.h>       // CMsvStore
#include <msvuids.h>        // KUidMsvMessageEntry
#include <mtmdef.h>	        // KMsvMessagePartBody

// user includes
#include "txtcmds.hrh"	// Commands that can be passed on to the server side.
#include "txtcpan.h"
#include "txtfwdop.h"   // CTxtMtmForwardOperation

_LIT(KTxtGeneratedFilename, "C:\\data\\TextMTMService\\sentmsgbody.txt"); // generated filename base

EXPORT_C CTextMtmClient* CTextMtmClient::NewL(CRegisteredMtmDll& aRegisteredMtmDll, CMsvSession& aMsvSession)
// Factory function
	{
	CTextMtmClient* self = new (ELeave) CTextMtmClient(aRegisteredMtmDll,aMsvSession);
	CleanupStack::PushL(self);
	self->ConstructL();
	CleanupStack::Pop();
	return self;
	}


CTextMtmClient::CTextMtmClient(CRegisteredMtmDll& aRegisteredMtmDll, CMsvSession& aMsvSession)
: CBaseMtm(aRegisteredMtmDll,aMsvSession)
	{
	__ASSERT_DEBUG(Type()==KUidMsgTypeText,gPanic(ETxtcBadMtmTypeUid));
	}

void CTextMtmClient::ConstructL()
	{
	iSettings = CMTMTxtSettings::NewL();
	SwitchCurrentEntryL(KMsvRootIndexEntryId);
	}

CTextMtmClient::~CTextMtmClient()
	{
	delete iSettings;
	}


void CTextMtmClient::SaveMessageL()
// Store entry data 
// If it is a service entry, store the current settings. Otherwise it has to be
// a message. 
//
	{

	__ASSERT_DEBUG(iMsvEntry!=NULL,gPanic(ETxtcNoCMsvEntrySet));
	TMsvEntry entry=iMsvEntry->Entry();

	switch (iMsvEntry->Entry().iType.iUid)
		{
		case KUidMsvServiceEntryValue:
		
			// Save settings to Central Repository
			iSettings->SaveSettingsL(iMsvEntry->Entry().Id(), iTxtSettings);
			break;
		case KUidMsvMessageEntryValue:
			// get an editable message store
			CMsvStore* store = iMsvEntry->EditStoreL();
			CleanupStack::PushL(store);
			StoreBodyL(*store);
			store->CommitL();
			CleanupStack::PopAndDestroy(store);
		
			// Make sure that we are visible and no longer in preparation
			entry.SetVisible(ETrue);
			entry.SetInPreparation(EFalse);
			entry.iServiceId=  KMsvLocalServiceIndexEntryId;
			_LIT(KNewFile,"message.txt");
   			entry.iDescription.Set(KNewFile);
   			iMsvEntry->ChangeL(entry);
   			break;
			
			
			
		default:
			__ASSERT_DEBUG(EFalse, gPanic(ETxtcEntryTypeNotSupported));
			break;
		}

	}

void CTextMtmClient::LoadMessageL()
// Restore entry data 
// Operation inverse to StoreL
//
	{
	__ASSERT_DEBUG(iMsvEntry!=NULL,gPanic(ETxtcNoCMsvEntrySet));



	switch (iMsvEntry->Entry().iType.iUid)
		{
		case KUidMsvServiceEntryValue:
			// Read settings from Central Repository
			iSettings->LoadSettingsL(iMsvEntry->Entry().Id(), iTxtSettings);
			break;
		case KUidMsvMessageEntryValue:
			// Get read-only message store.
    		// ReadStoreL leaves if the entry doesn't have a message store.
    		CMsvStore* store = iMsvEntry->HasStoreL() ? iMsvEntry->ReadStoreL() : NULL;
			if (store==NULL) return;
			CleanupStack::PushL(store);
			RestoreBodyL(*store);
			CleanupStack::PopAndDestroy(); // store	
			break;
		default:
			__ASSERT_DEBUG(EFalse, gPanic(ETxtcEntryTypeNotSupported));
			break;
		}

	}


CMsvOperation* CTextMtmClient::ReplyL (TMsvId /*aDestination*/, TMsvPartList /*aPartlist*/, 
									   TRequestStatus& /*aCompletionStatus*/)
// Create reply message 
// Reply is not defined
//
	{
	User::Leave(KErrNotSupported);
	return NULL;
	}


CMsvOperation* CTextMtmClient::ForwardL(TMsvId aDestination, TMsvPartList /*aPartList*/, TRequestStatus& aCompletionStatus)
// Create forwarded message 
// Destination folder is aForwardEntryL
//
	{
	__ASSERT_DEBUG(iMsvEntry!=NULL,gPanic(ETxtcNoCMsvEntrySet));
	__ASSERT_DEBUG(iMsvEntry->Entry().iType.iUid == KUidMsvMessageEntryValue, gPanic(ETxtcEntryTypeNotSupported));
	__ASSERT_DEBUG(iMsvEntry->Entry().iServiceId == KMsvLocalServiceIndexEntryId, gPanic(ETxtcInvalidServiceId));
	
    return CTxtMtmForwardOperation::NewL(Entry().EntryId(), aDestination, Session(), aCompletionStatus);
	}


TMsvPartList CTextMtmClient::ValidateMessage(TUint aPartList)
// Message validation
//
// The only thing about the message that can be invalid
// is the iDescription, which should be an acceptable file name. So, length isn't 
// allowed to be zero, and backslashes are not allowed in iDescription.
//
	{
	__ASSERT_DEBUG(iMsvEntry!=NULL,gPanic(ETxtcNoCMsvEntrySet));
	TInt retVal=0;
	if (aPartList & KMsvMessagePartDescription)
		{
		if (iMsvEntry->Entry().iDescription.Length() == 0)
			{
			retVal |= KMsvMessagePartDescription;
			}
		else if (iMsvEntry->Entry().iDescription.Locate( TChar('\\')) >= 0)
			{
			retVal |= KMsvMessagePartDescription;
			}
		}
	return retVal;
	}


TMsvPartList CTextMtmClient::Find(const TDesC& aTextToFind, TMsvPartList aPartList)
// Find text in entry 
	{
	__ASSERT_DEBUG(iMsvEntry!=NULL, gPanic(ETxtcNoCMsvEntrySet));
    TMsvPartList retVal = KMsvMessagePartNone;
	if (aPartList & KMsvMessagePartBody)
		{
		CRichText& body = Body();

		if (body.DocumentLength() > 0)
			{
			// Get searchable text
            TPtrC theText = body.Read(0);
            if(theText.FindF(aTextToFind) != KErrNone)
                retVal |= KMsvMessagePartBody;
			}
		}

	if (aPartList & KMsvMessagePartOriginator)
		{
		if (iMsvEntry->Entry().iDetails.FindF( aTextToFind ) >= 0)
			{
			retVal |= KMsvMessagePartOriginator;
			}
		}
	
	if (aPartList & KMsvMessagePartDescription)
		{
		if (iMsvEntry->Entry().iDescription.FindF( aTextToFind ) >= 0)
			{
			retVal |= KMsvMessagePartDescription;
			}
		}
	
	// Never searched - KMsvMessagePartAttachments, KMsvMessagePartRecipient 
	// and KMsvMessagePartDate
	return retVal;
	}

TInt CTextMtmClient::QueryCapability(TUid aCapability, TInt& aResponse)
// Query for capability 
	{
	TInt error = KErrNone;
	switch (aCapability.iUid)
		{
		case KUidMtmQueryMaxBodySizeValue:
		case KUidMtmQueryMaxTotalMsgSizeValue:
			aResponse = KMaxTextMessageSize;
			break;
		case KUidMtmQuerySupportedBodyValue:
			aResponse = KMtm8BitBody + KMtm7BitBody;
			break;
		case KUidMtmQueryOffLineAllowedValue:
		case KUidMtmQueryCanReceiveMsgValue:
			aResponse = 0;
			break;
	
		default:
			return KErrNotSupported;
		}
	return error;
	}

void CTextMtmClient::InvokeSyncFunctionL(TInt aFunctionId, const CMsvEntrySelection& aSelection, TDes8& aParameter)
// Call MTM-specific operation synchronously
	{
	TInt error = KErrNone;
	CMsvOperationActiveSchedulerWait* wait=CMsvOperationActiveSchedulerWait::NewLC();
	CMsvOperation* operation = InvokeAsyncFunctionL(aFunctionId,aSelection, aParameter, wait->iStatus);
	if (operation != NULL)
		{
		wait->Start();
		error = wait->iStatus.Int();
		delete operation;
		}
	else
		{
		error=KErrNotSupported;
		}
	CleanupStack::PopAndDestroy(); // wait
	
	}

CMsvOperation* CTextMtmClient::InvokeAsyncFunctionL(TInt aFunctionId,
													const CMsvEntrySelection& aSelection, 
													TDes8& aParameter, 
													TRequestStatus& aCompletionStatus)
// Call MTM-specific operation asynchronously
	{
	CMsvOperation* operation = NULL;
	switch (aFunctionId)
		{
		case KTXTMTMRefresh:
            {
            operation = (Entry().Session().TransferCommandL(aSelection, aFunctionId, aParameter, aCompletionStatus));
            }
			break;
		case KTXTMTMMessageCommand:
			{
			__ASSERT_DEBUG(EFalse,gPanic(ETxtcCommandNotSupported));
			break;		
			}
		default:
			__ASSERT_DEBUG(EFalse,gPanic(ETxtcCommandNotSupported));
			break;
		}
	return operation;
	}


void CTextMtmClient::ContextEntrySwitched() 
// Context change notification 
//
// No need to know entry changes
//
	{
	}

// attachments are not supported for this MTM
void CTextMtmClient::CreateAttachmentL(const TDesC& , const TDesC8& , TRequestStatus& )
	{
	User::Leave(KErrNotSupported);
	}
	
void CTextMtmClient::CreateAttachmentL(RFile& , const TDesC8& , TRequestStatus& )
	{
	User::Leave(KErrNotSupported);
	}

void CTextMtmClient::CreateLinkedAttachmentL(const TDesC& , const TDesC8& , TRequestStatus& )
	{
	User::Leave(KErrNotSupported);
	}

void CTextMtmClient::CreateMessageAttachmentL(TMsvId , TRequestStatus& )
	{
	User::Leave(KErrNotSupported);
	}

// delegate default service storage to CMTMTxtSettings
TMsvId CTextMtmClient::DefaultServiceL() const
	{
	return iSettings->DefaultServiceL();
	}
	
void CTextMtmClient::RemoveDefaultServiceL()
	{
	iSettings->DeleteDefaultServiceSettingL();
	}
	
void CTextMtmClient::ChangeDefaultServiceL(const TMsvId& aService)
	{
	iSettings->SetDefaultServiceL(aService);	
	}

// Empty implementation for SetSubjectL and SubjectL fixed
// 'Feature Not Supported' on E-series devices. For details, see
// see http://www.forum.nokia.com/document/Forum_Nokia_Technical_Library/contents/FNTL/Send_via_E-mail_fails_in_Nokia_Eseries_devices_with_a_3rd_party_MTM.htm
//
// Empty implementations also fixed viewer => viewer now can render
// message directly from Text MTM mailbox - no need to
// to move messages to global inbox for viewing
void CTextMtmClient::SetSubjectL(const TDesC& //aSubject
        )
    {
    }

const TPtrC CTextMtmClient::SubjectL() const
    {
    return TPtrC(KNullDesC);
    }
