// TXTCPAN.H
//
//  2004 Nokia Corporation.  All rights reserved.
//

// class include
#include "txtfwdop.h"

//system include
#include <txtrich.h>

// user include
#include "txtcpan.h"

CTxtMtmForwardOperation* CTxtMtmForwardOperation::NewL(TMsvId aSourceMessage, TMsvId aDestinationFolder, CMsvSession& aMsvSession, TRequestStatus& aObserverRequestStatus)
    {
    CTxtMtmForwardOperation* self = new (ELeave) CTxtMtmForwardOperation(aSourceMessage, aDestinationFolder, aMsvSession, aObserverRequestStatus);
    CleanupStack::PushL(self);
    self->ConstructL();
    CleanupStack::Pop(self);
    return self;
    }

CTxtMtmForwardOperation::~CTxtMtmForwardOperation()
    {
    delete iMsvEntry;
    }

const TDesC8& CTxtMtmForwardOperation::ProgressL()
    {
    if(!IsActive())
        User::Leave(KErrNotReady);
    iProgressBuf() = iProgress;
    return iProgressBuf;
    }

const TDesC8& CTxtMtmForwardOperation::FinalProgress()
    {
    __ASSERT_ALWAYS(!IsActive(), User::Panic(KTxtCPanic, ETxtcOperationIsActive));
    iProgressBuf() = iProgress;
    return iProgressBuf;
    }

TInt CTxtMtmForwardOperation::RunError(TInt aError)
    {
    // Remove an entry if one's been created by this method
    if(iProgress.iState > TTxtMtmForwardOpProgress::ECreateMessage)
        iMsvSession.RemoveEntry(iProgress.iFinalMsgId);

    // Populate the progress structure with the error code
    iProgress.iError = aError;    
    // Complete the requesting active object with the error code
    TRequestStatus* stat = &iObserverRequestStatus;
    User::RequestComplete(stat, aError);
    // Returning anything other than KErrNone from this method results in a panic
    return KErrNone;
    }

void CTxtMtmForwardOperation::DoCancel()
    {
    if(iProgress.iState > TTxtMtmForwardOpProgress::ECreateMessage)
        iMsvSession.RemoveEntry(iProgress.iFinalMsgId);

    TRequestStatus* stat = &iObserverRequestStatus;
    User::RequestComplete(stat, KErrCancel);
    }

void CTxtMtmForwardOperation::RunL()
    {
    User::LeaveIfError(iStatus.Int());

    switch(iProgress.iState)
        {        
        case TTxtMtmForwardOpProgress::EInit:
            iProgress.iState = TTxtMtmForwardOpProgress::ECreateMessage;
            CreateMessageL();   // reschedules the active object
            break;

        case TTxtMtmForwardOpProgress::ECreateMessage:
            iProgress.iState = TTxtMtmForwardOpProgress::EFormatBodyText;
            FormatBodyTextL();  // reschedules the active object
            break;

        case TTxtMtmForwardOpProgress::EFormatBodyText:
            iProgress.iState = TTxtMtmForwardOpProgress::EFinished;
        
        default:
            break;
        }

    // When the state machine has been completed, this active object won't
    // be scheduled to complete a request
    if(!IsActive())
        {
        TRequestStatus* stat = &iObserverRequestStatus;
        User::RequestComplete(stat, KErrNone);
        }
    }

void CTxtMtmForwardOperation::CreateMessageL()
    {
    delete iMsvEntry;
    iMsvEntry = NULL;
    iMsvEntry = iMsvSession.GetEntryL(iSourceMessage);
        
    // Get the entry to be forwarded    
	TMsvEntry forwardEntry = iMsvEntry->Entry();	

    // Set the context to the destination folder
    iMsvEntry->SetEntryL(iDestinationFolder);

    // Create the forwarded index entry
    forwardEntry.iDate.HomeTime();
    iMsvEntry->CreateL(forwardEntry);
    iProgress.iFinalMsgId = forwardEntry.Id();

    // schedules the active object to complete so that this class's RunL method
    // will be called by the active scheduler
    SetActive();
    TRequestStatus* stat = &iStatus;
    User::RequestComplete(stat, KErrNone);
    }

void CTxtMtmForwardOperation::FormatBodyTextL()
    {
    CParaFormatLayer* paraLayer = CParaFormatLayer::NewL();
    CleanupStack::PushL(paraLayer);
    CCharFormatLayer* charLayer = CCharFormatLayer::NewL();
    CleanupStack::PushL(charLayer);
    CRichText* body = CRichText::NewL(paraLayer, charLayer);
    CleanupStack::PushL(body);
 
    // Get the message store from the source entry
    iMsvEntry->SetEntryL(iSourceMessage);
    CMsvStore* readStore = iMsvEntry->ReadStoreL();
    CleanupStack::PushL(readStore);
        
    // Get the message store from the newly created destination entry
    iMsvEntry->SetEntryL(iProgress.iFinalMsgId);
    CMsvStore* writeStore = iMsvEntry->EditStoreL();
    CleanupStack::PushL(writeStore);

    // Get the body text from the source entry and write it
    // to the destination entry, prepending the forward 
    // prefix
    readStore->RestoreBodyTextL(*body);
    body->InsertL(0, KTxtMtmFwdPrefix);

 	// this method performs a commit for us
     writeStore->StoreBodyTextL(*body);
 
    CleanupStack::PopAndDestroy(5, paraLayer); 

    // schedules the active object to complete so that this class's RunL method
    // will be called by the active scheduler
    SetActive();
    TRequestStatus* stat = &iStatus;
    User::RequestComplete(stat, KErrNone);

    }

CTxtMtmForwardOperation::CTxtMtmForwardOperation(TMsvId aSourceMessage, TMsvId aDestinationFolder, CMsvSession& aMsvSession, TRequestStatus& aObserverRequestStatus)
 :  CMsvOperation(aMsvSession, EPriorityStandard, aObserverRequestStatus),
    iSourceMessage(aSourceMessage),
    iDestinationFolder(aDestinationFolder)
    {
    CActiveScheduler::Add(this);
    }

void CTxtMtmForwardOperation::ConstructL()
    {
    // set the requesting active object's request status to pending so that
    // it doesn't complete
    iObserverRequestStatus = KRequestPending;

    // schedules the active object to complete so that this class's RunL method
    // will be called by the active scheduler
    SetActive();
    TRequestStatus* stat = &iStatus;
    User::RequestComplete(stat, KErrNone);

    // Note that the active object is scheduled here instead of calling CreateMessageL() so that 
    // leaves are handled in the RunError method
    }
