//
//  2004 Nokia Corporation.  All rights reserved.
//

#ifndef __TXTMTMEDITOP_H__
#define __TXTMTMEDITOP_H__

// system include
#include <msvapi.h>

// user include
#include "txtu.h"	 //CTextMtmUi

//
//	CTxtMtmEditRemoteOperation: remote edit operation that copies a remote
//  entry to the inbox before invoking the editor/viewer on the copy
//
class CTxtMtmEditRemoteOperation : public CMsvOperation
	{
    public:
	    enum TEditRemoteState
		    {
		    EStateFinished=0,
		    EStateEditing,
		    EStateCopying
		    };
	
	public:
		CTxtMtmEditRemoteOperation(CTextMtmUi& aMtmUi, CMsvSession& aMsvSession, 
			TInt aPriority, TRequestStatus& aObserverRequestStatus);
		~CTxtMtmEditRemoteOperation();

    public:
        void StartL(TMsvEntry& aSourceEntry);

	public:	// from CMsvOperation		
		virtual const TDesC8& ProgressL();

	private:	// from CActive
		virtual void DoCancel();
		virtual void RunL();
        virtual TInt RunError(TInt aError);

	protected:
		CTextMtmUi& iMtmUi;
	private:
		
		TBuf8<10> iProgress;
		CMsvOperation* iCopyOperation;
		CMsvOperation* iEditOperation;
		TEditRemoteState iState;
	};

#endif  // __TXTMTMEDITOP_H__
