////
//  2004 Nokia Corporation.  All rights reserved.
//

#ifndef __TXTMTMEDITOROP_H__
#define __TXTMTMEDITOROP_H__

#include <mtmuibas.h>
#include <msvapi.h>     // CMsvOperation
#include <apparc.h>
#include <eikdoc.h>		// CEikDocument
#include "TxtViewerService.h"
#include <apaserverapp.h> 
// generated filename base
//const TUid KUidMsvEditorParameterValue = {0x100014AA};
//const TUid KUidTextMTMView = { 0x05B22967 };
// Progress information for create operation

class CTextMtmUi;

class TTxtMtmEditorOpProgress
    {
    public:
        enum TState
            {
            EInit,
			EEditorLaunched,
			EEditorOpen,
            EFinished
            };

    public:
        TState iState;
        TInt iError;
    };

// utility typedef of package buffer
typedef TPckgBuf <TTxtMtmEditorOpProgress> TTxtMtmEditorOpProgressBuf;

class TTextMtmEditorParams
	{
	public:
		enum TLaunchType {EEditor,EViewer};
	public:
		TMsvId iMessage;
		TLaunchType iLaunchType;
	};

class CTxtMtmEditorOperation : public CMsvOperation, public MAknServerAppExitObserver
	{
	public:
		enum TOpenMode {EEdit,EView};
	public:
        static CTxtMtmEditorOperation* NewL(const TMsvId& aId,TOpenMode aMode, CMsvSession& aMsvSession, TRequestStatus& aObserverRequestStatus,CTextMtmUi& aMtmUi);
        ~CTxtMtmEditorOperation();

	public:	// from CMsvOperation
		virtual const TDesC8& ProgressL();
        virtual const TDesC8& FinalProgress();
		void HandleServerAppExit( TInt aReason );

    private:
        void LaunchEditorL();
		void SendL(); 
		CTxtMtmEditorOperation(const TMsvId& aId, TOpenMode aMode, CMsvSession& aMsvSession, TRequestStatus& aObserverRequestStatus,CTextMtmUi& aMtmUi);
        void ConstructL();

	private:// from CActive
		virtual void RunL();
		virtual void DoCancel();
        virtual TInt RunError(TInt aError);

    private:
		TTxtMtmEditorOpProgress iProgress;
        TTxtMtmEditorOpProgressBuf iProgressBuf;
		TMsvId iId;
		TOpenMode iMode;
		RTxtViewerService iService;
		CEikDocument* iDocument;
		CApaServerAppExitMonitor* iMonitor;
		CTextMtmUi& iMtmUi;
	};

#endif  // __TXTMTMEDITOROP_H__
