//
//  2004 Nokia Corporation.  All rights reserved.
//

// class include
#include "txtmtmcreateop.h"

//system include
#include <apparc.h>    // CApaApplication
#include <msvids.h>    // KMsvLocalServiceIndexEntryId
#include <msvuids.h>   // KUidMsvMessageEntry
#include <ecom.h>
#include <txtrich.h>
// user include
#include "txtupan.h"
#include "txtu.h"

#include "TXTCMDS.HRH"



// constants
_LIT(KTxtGeneratedFilename, "C:\\data\\TextMTMService\\sentmsgbody.txt"); // generated filename base
_LIT(KDefaultMtmName, "My TextMTM");
CTxtMtmCreateOperation* CTxtMtmCreateOperation::NewL(const TMsvEntry& aEntry, CMsvEntry& aParent, CMsvSession& aMsvSession, CBaseMtmUi& aMtmUi, TRequestStatus& aObserverRequestStatus)
    {
    CTxtMtmCreateOperation* self = new (ELeave) CTxtMtmCreateOperation(aEntry, aParent, aMsvSession, aMtmUi, aObserverRequestStatus);
    CleanupStack::PushL(self);
    self->ConstructL();
    CleanupStack::Pop(self);
    return self;
    }

CTxtMtmCreateOperation::CTxtMtmCreateOperation(const TMsvEntry& aEntry, CMsvEntry& aParent, CMsvSession& aMsvSession, CBaseMtmUi& aMtmUi, TRequestStatus& aObserverRequestStatus)
 :  CMsvOperation(aMsvSession, EPriorityStandard, aObserverRequestStatus),
    iEntry(aEntry),
    iParent(aParent),
    iMtmUi(aMtmUi)
    {
    CActiveScheduler::Add(this);
    }

void CTxtMtmCreateOperation::ConstructL()
    {
    // set the obeserver request status as pending so that the observer
    // won't complete
    iObserverRequestStatus = KRequestPending;    
    
    Schedule(KErrNone);
    }

CTxtMtmCreateOperation::~CTxtMtmCreateOperation()
    {
    Cancel();
    delete iOp;
    }

const TDesC8& CTxtMtmCreateOperation::ProgressL()
    {
    if(!IsActive())
        User::Leave(KErrNotReady);
    iProgressBuf() = iProgress;
    return iProgressBuf;
    }

const TDesC8& CTxtMtmCreateOperation::FinalProgress()
    {
    __ASSERT_ALWAYS(!IsActive(), User::Panic(KTEXTMTMUIPanic, ETextMtmUiOperationActive));
    iProgressBuf() = iProgress;
    return iProgressBuf;
    }

TInt CTxtMtmCreateOperation::RunError(TInt aError)
    {
    if(iProgress.iState > TTxtMtmCreateOpProgress::ECreateMessage)
        iMsvSession.RemoveEntry(iProgress.iFinalMsgId);

    // Populate the progress structure with the error code
    iProgress.iError = aError;    
    // Complete the requesting active object with the error code
    TRequestStatus* stat = &iObserverRequestStatus;
    User::RequestComplete(stat, aError);
    // Returning anything other than KErrNone from this method results in a panic
    return KErrNone;
    }

void CTxtMtmCreateOperation::DoCancel()
    {
    if(iOp)
        iOp->Cancel();

    if(iProgress.iState > TTxtMtmCreateOpProgress::ECreateMessage)
        iMsvSession.RemoveEntry(iProgress.iFinalMsgId);

    TRequestStatus* stat = &iObserverRequestStatus;
    User::RequestComplete(stat, KErrCancel);
    }

void CTxtMtmCreateOperation::RunL()
    {
    User::LeaveIfError(iStatus.Int());

    switch(iProgress.iState)
        {        
        case TTxtMtmCreateOpProgress::EInit:
            iProgress.iState = TTxtMtmCreateOpProgress::ECreateMessage;
            CreateMessageL();  // reschedules the active object
            break;

        case TTxtMtmCreateOpProgress::ECreateMessage:
            iProgress.iState = TTxtMtmCreateOpProgress::EEditMessage;
            ScheduleEditL();  // reschedules the active object
            break;

        case TTxtMtmCreateOpProgress::EEditMessage:
            iProgress.iState = TTxtMtmCreateOpProgress::EFinished;
            
        
        default:
            break;
        }

    // When the state machine has been completed, this active object won't
    // be scheduled to complete a request
    if(!IsActive())
        {
        TRequestStatus* stat = &iObserverRequestStatus;
        User::RequestComplete(stat, KErrNone);
        }
    }


void CTxtMtmCreateOperation::CreateMessageL()
    {
    
    
	TFileName filename = KTxtGeneratedFilename();
    if( iEntry.iType == KUidMsvMessageEntry)
        {
        _LIT(KFilename,"message.txt");
	    iEntry.iDescription.Set(KFilename);
	    iEntry.iDate.UniversalTime();
        iEntry.iServiceId=KMsvLocalServiceIndexEntryId;
        iParent.SetEntryL(KMsvDraftEntryId);
    	iParent.CreateL(iEntry);
		iProgress.iFinalMsgId = iEntry.Id();
		}
    else
    	{
    	if (iEntry.iType ==KUidMsvServiceEntry)
        	{ 
        	iEntry.iDetails.Set(KDefaultMtmName);
        	iParent.SetEntryL(KMsvRootIndexEntryId);
    		iParent.CreateL(iEntry);
    		iProgress.iFinalMsgId = iEntry.Id();
    		
    		// Set the root folder setting
            _LIT(KRoot, "C:\\data\\TextMTMService\\");
    		TMTMTxtSettings set;
			CMTMTxtSettings* settings = CMTMTxtSettings::NewL();
			set.SetRootFolder(KRoot);
			CleanupStack::PushL(settings);
			settings->SaveSettingsL(iEntry.Id(), set);
			CleanupStack::PopAndDestroy(settings);
			}
    	}
	Schedule(KErrNone);
    }

void CTxtMtmCreateOperation::ScheduleEditL()
    {
    iMtmUi.BaseMtm().SwitchCurrentEntryL(iProgress.iFinalMsgId);
    
    delete iOp;
    iOp = NULL; 
    
    // The Edit method returns a CMsvOperation that will complete this class's request status 
    // when editing is complete, resulting in this class's RunL method being called by the active scheduler
    SetActive();

    iOp = iMtmUi.EditL(iStatus);
    }

void CTxtMtmCreateOperation::Schedule(TInt aError)
    {    
    // Schedules the transaction so that the RunL method of this active
    // object will get called again
    SetActive();
    TRequestStatus* stat = &iStatus;
    User::RequestComplete(stat, aError);
    }

