//
//  2004 Nokia Corporation.  All rights reserved.
//

// class include
#include "txtmtmeditop.h"

// system include
#include <msvids.h>

// ----------------------------------------------------------------------------
//
//	CTxtMtmEditRemoteOperation: remote edit operation
//
// ----------------------------------------------------------------------------
CTxtMtmEditRemoteOperation::CTxtMtmEditRemoteOperation(CTextMtmUi& aMtmUi, CMsvSession& aMsvSession, 
										   TInt aPriority, TRequestStatus& aObserverRequestStatus)
	: CMsvOperation(aMsvSession, aPriority, aObserverRequestStatus), iMtmUi(aMtmUi)
	{
    CActiveScheduler::Add(this);
	}

// ----------------------------------------------------------------------------
CTxtMtmEditRemoteOperation::~CTxtMtmEditRemoteOperation()
	{
	Cancel();
	delete iCopyOperation;
	delete iEditOperation;
	}


// ----------------------------------------------------------------------------
const TDesC8& CTxtMtmEditRemoteOperation::ProgressL() 
	{
	return iProgress;
	}


// ----------------------------------------------------------------------------
//
// cancel any outstanding operations
//
void CTxtMtmEditRemoteOperation::DoCancel()
	{
	switch (iState)
		{
		case EStateCopying:
            {
            if(iCopyOperation)
			    iCopyOperation->Cancel();
            }
			break;
		case EStateEditing:
            {
            if(iEditOperation)
			    iEditOperation->Cancel();
            }
			break;
		default:
			break;
		}
	}


// ----------------------------------------------------------------------------
//
// asynchronously copy the entry from the remote service to the inbox
//
void CTxtMtmEditRemoteOperation::StartL(TMsvEntry& aSourceEntry)
	{
	CMsvEntry* cEntry=iMsvSession.GetEntryL(aSourceEntry.Parent());
	CleanupStack::PushL(cEntry);
	iObserverRequestStatus = KRequestPending;
	SetActive();
	iCopyOperation=cEntry->CopyL(aSourceEntry.Id(), KMsvDraftEntryId/*KMsvGlobalInBoxIndexEntryId*/, iStatus);
	CleanupStack::PopAndDestroy(cEntry);// cEntry
	iState = EStateCopying;
	}


// ----------------------------------------------------------------------------
void CTxtMtmEditRemoteOperation::RunL()
	{
	switch (iState)
		{
		case EStateCopying:
			{
            // launch the viewer application if the entry copy operation
            // was successful
			TTxtProgressBuf package;
			package.Copy(iCopyOperation->ProgressL());
            
            User::LeaveIfError(package().iErrorCode);
			TMsvId newid = package().iNewId;

			iStatus = KRequestPending;
			SetActive();
			iEditOperation = iMtmUi.LaunchViewerApplicationL(iStatus, newid);
			iState = EStateEditing;
			}
			break;
		case EStateEditing:
			{
            // the user has finished editing, so complete the requesting
            // active object
			iState = EStateFinished;
			TRequestStatus *sP = &iObserverRequestStatus;
			User::RequestComplete(sP,iStatus.Int());
			}
			break;
		default:
			break;
		}
	}


// ----------------------------------------------------------------------------
//
// This method gets called if there's a leave in RunL
//
TInt CTxtMtmEditRemoteOperation::RunError(TInt aError)
    {
	TRequestStatus *sP = &iObserverRequestStatus;
	User::RequestComplete(sP, aError);
    return KErrNone;
    }
