// TXTI.H
//
//  2004 Nokia Corporation.  All rights reserved.
//

#if !defined(__TXTI_H__)
#define __TXTI_H__

// system includes
#include <msvstd.h>
#include <mtudcbas.h>


//
// CTxtiMtmUiData: UI Data MTM
//

class CTxtiMtmUiData : public CBaseMtmUiData
	{
public:
	// Construction, initialisation, and destruction 
	static CTxtiMtmUiData* NewL(CRegisteredMtmDll& aRegisteredDll);
	~CTxtiMtmUiData();
	virtual void PopulateArraysL();
	virtual void GetResourceFileName(TFileName& aFileName) const;
	
	// MTM-specific functionality 
	virtual TInt OperationSupportedL(TInt aOperationId, const TMsvEntry& aContext) const;
	virtual TInt QueryCapability(TUid aCapability, TInt& aResponse) const;

	// Context-specific information 
	virtual TBool CanEditEntryL(const TMsvEntry& aContext, TInt& aReasonResourceId) const;
	virtual TBool CanViewEntryL(const TMsvEntry& aContext, TInt& aReasonResourceId) const;
	virtual TBool CanOpenEntryL(const TMsvEntry& aContext, TInt& aReasonResourceId) const;
	virtual TBool CanCloseEntryL(const TMsvEntry& aContext, TInt& aReasonResourceId) const;
	virtual TBool CanDeleteFromEntryL(const TMsvEntry& aContext, TInt& aReasonResourceId) const;
	virtual TBool CanCopyMoveToEntryL(const TMsvEntry& aContext, TInt& aReasonResourceId) const;
	virtual TBool CanCopyMoveFromEntryL(const TMsvEntry& aContext, TInt& aReasonResourceId) const;
	virtual TBool CanReplyToEntryL(const TMsvEntry& aContext, TInt& aReasonResourceId) const;
	virtual TBool CanForwardEntryL(const TMsvEntry& aContext, TInt& aReasonResourceId) const;
	virtual TBool CanCreateEntryL(const TMsvEntry& aContext,TMsvEntry& aNewEntry, TInt& aReasonResourceId) const;
	virtual TBool CanDeleteServiceL(const TMsvEntry& aService, TInt& aReasonResourceId) const;
	virtual TBool CanCancelL(const TMsvEntry& aContext, TInt& aReasonResourceId) const;
	
	virtual HBufC* StatusTextL(const TMsvEntry& aContext) const;

// Context-specific icons 
	virtual const CBitmapArray& ContextIcon(const TMsvEntry& aContext,TInt aStateFlags) const;

private:
	CTxtiMtmUiData(CRegisteredMtmDll& aRegisteredDll);
    void TxtConstructL();
	void TxtCreateBitmapsL(const TDesC& aBitmapFile);
//	FbsBitmap* TxtCreateBitmapL(const TDesC& aFileName, TInt aId) const;

private:
    TInt iNewResourceFileOffset;
    HBufC* iResourceFileName;
	};

#endif // __TXTI_H__
