// TXUT.H
//
//  2004 Nokia Corporation.  All rights reserved.
//

#ifndef __TXUT_H__
#define __TXUT_H__

#include <e32std.h>
#include <msvapi.h>             // TMsvId, CMsvOperation, CMsvSession


// TextMTM UIDs
LOCAL_D const TInt KUidMsgTypeTextValue = 0x10005247; 
LOCAL_D const TUid KUidMsgTypeText = { KUidMsgTypeTextValue};
LOCAL_D const TUid KTxtMtmTechnologyTypeUid	= {KUidMsgTypeTextValue };

LOCAL_D const TUid KUidMsvMtmTextServerDLL	={0x101FDA9C};
LOCAL_D const TUid KUidMsvMtmTextClientDLL	={0x101FDA9B};
LOCAL_D const TUid KUidMsvMtmTextUiDLL		={0x101FDA9D};
LOCAL_D const TUid KUidMsvMtmTextUiDataDLL	={0x101FDA9E};
LOCAL_D const TUid KUidTextMtmVersion1		={ KUidMsgTypeTextValue};

// Constants
LOCAL_D const TInt KUidTxtMTMSettingsValue = 0x1000525A; 
LOCAL_D const TUid KUidTxtMTMSettings={KUidTxtMTMSettingsValue};
LOCAL_D const TInt KMaxTextMessageSize = 0xFFFF;


//
//	TTxtProgress: Operation progress information
//
class TTxtProgress 
	{
public:
	TInt		iTotalMsgs;
	TInt		iMsgsProcessed;
	TInt		iErrorCode;     // client side needs to be informed of an error
	TMsvId		iNewId;	        // Used with CreateL, or any copy/move, storing the last moved message id.
	};

//
//  Package buffer of progress structure
//
typedef TPckgBuf<TTxtProgress> TTxtProgressBuf;

//
// TxtUtils: Generic static utility functions
// 
class TxtUtils
	{
public: 
	// Build file name for associated entry, given its entry.
	IMPORT_C static void GetEntryFileNameL(TFileName& aFileName, TMsvEntry& aEntry);
    // Prepends the drive letter to aFileName found in aLocation 
    IMPORT_C static void FindFileL(const TDesC& aFileName, const TDesC& aLocation, TFileName& aRetVal);
	};

//
// TMTMTxtSettings: contains the settings for a service. It can be stored in the CMsvStore
// associated with the service entry.
//
class TMTMTxtSettings 
	{
public:
	IMPORT_C void StoreL(CMsvStore& aMsvStore) const;
	IMPORT_C void RestoreL(const CMsvStore& aMessageStore );
	IMPORT_C void ExternalizeL( RMsvWriteStream& aWriteStream ) const;
	IMPORT_C void InternalizeL( RMsvReadStream& aReadStream );

public:
	TPtrC RootFolder() const;
	void SetRootFolder(const TDesC& aRootFolder);

private:
	TFileName iRootFolder;
 

	};


//
// CMsvOpWait:
//	Allows a synchronous wait on a operation
//

class CMsvOpWait: public CActive
	{
public:
	IMPORT_C static CMsvOpWait* NewLC(TInt aPriority=EPriorityStandard);
	IMPORT_C ~CMsvOpWait();
	IMPORT_C void Start();

protected:
	CMsvOpWait(TInt aPriority);

protected:
    // from CActive
	virtual void RunL();
	virtual void DoCancel();
	};


//
// CMsvCompOperation: 
//	An operation which is already completed on construction
//
class CMsvCompOperation : public CMsvOperation
	{
public:
	IMPORT_C static CMsvCompOperation* NewL(CMsvSession& aMsvSession, TUid aMtm, const TDesC8& aProgress, TMsvId aService, TRequestStatus& aObserverRequestStatus, TInt aErr=KErrNone);
	IMPORT_C ~CMsvCompOperation();

public:
    // from CMsvOperation
	virtual const TDesC8& ProgressL();

private:
	CMsvCompOperation(CMsvSession& aSession, TRequestStatus& aObserverRequestStatus);
	void ConstructL(TUid aMtm, TInt aError, const TDesC8& aProgress, TMsvId aService);

private:
	// from CActive
	virtual void DoCancel();
	virtual void RunL();

private:
	HBufC8* iProgress;
	};


//
// inline implementations
//
inline void TMTMTxtSettings::SetRootFolder(const TDesC& aRootFolder) 
	{
	iRootFolder = aRootFolder;
	}

inline TPtrC TMTMTxtSettings::RootFolder() const 
	{ 
	return iRootFolder; 
	}

class CRepository;

/** From 9.0, this class is used to 
 store/load settings into the central repository.
 It also saves/loads a setting to identify a default textmtm service.
 */
class CMTMTxtSettings: public CBase
	{
public:
	IMPORT_C static CMTMTxtSettings* NewL();
	~CMTMTxtSettings();
	// load, save, and delete text mtm settings
	IMPORT_C void LoadSettingsL(TMsvId aServiceId, TMTMTxtSettings& aSettings) const;
	IMPORT_C void SaveSettingsL(TMsvId aServiceId, const TMTMTxtSettings& aSettings);
	IMPORT_C void DeleteSettingsL(TMsvId aServiceId);
	// handle a setting that specifies what the default service is
	IMPORT_C TMsvId DefaultServiceL() const;
	IMPORT_C void SetDefaultServiceL(TMsvId aService);
	IMPORT_C void DeleteDefaultServiceSettingL();
	
private:
	void ConstructL();	
	void CreateOrSetL(TUint aKey, const TDesC& aValue);
	void CreateOrSetL(TUint aKey, TInt aValue);
	TUint32 FindAccountL(TMsvId aService) const;
	TUint GetNextAccountSlotL();
	void DeleteSettingL(TUint32 settingId);
	
private:
	CRepository* iRepository;
	};
#endif // __TXUT_H__

