/*
* ============================================================================
*  Name     : CTxtViewerAppServer 
*  Part of  : TxtViewer
*
*  Description:
*             Provides CTxtViewerAppServer class methods.
*
*  Version:
*
*  Copyright (C) 2002 Nokia Corporation.
*  This material, including documentation and any related
*  computer programs, is protected by copyright controlled by
*  Nokia Corporation. All rights are reserved. Copying,
*  including reproducing, storing,  adapting or translating, any
*  or all of this material requires the prior written consent of
*  Nokia Corporation. This material also contains confidential
*  information which may not be disclosed to others without the
*  prior written consent of Nokia Corporation.
*
* ============================================================================
*/

// INCLUDES
#include "TxtViewerAppServer.h"
#include "TxtViewerServiceSession.h"

#define KTxtViewerServiceUid    	0x10FFFFFF

// Service types
#define KMsgServiceView				0x00000001
#define KMsgServiceEdit				0x00000002
//////////////////////////


#include <aknserverapp.h>


// ================= MEMBER FUNCTIONS =======================
// -----------------------------------------------------------------------------
// CTxtViewerAppServer::CreateServiceL
//
// -----------------------------------------------------------------------------
//
CApaAppServiceBase* CTxtViewerAppServer::CreateServiceL( TUid aServiceType ) const
    {
   	if (aServiceType == TUid::Uid(KTxtViewerServiceUid))
        {
		return new(ELeave) CTxtViewerServiceSession;
        }
  	return CEikAppServer::CreateServiceL(aServiceType);
    }
// -----------------------------------------------------------------------------
// CTxtViewerAppServer::CreateServiceL
//
// -----------------------------------------------------------------------------
//

CPolicyServer::TCustomResult CTxtViewerAppServer::CustomFailureActionL(
    const RMessage2& /*aMsg*/,
    TInt /*aAction*/,
    const TSecurityInfo& /*aMissing*/ )
    {
    CPolicyServer::TCustomResult res = CPolicyServer::EPass;
    return res;
    }

//  End of File
