

#include "TxtViewerServiceSession.h"

#include "../../UI/inc/TxtViewerService.h"


#include <ApgCli.h>
#include <eikenv.h>
#include <eikappui.h>
#include <mmsconst.h>
#include <AknServerApp.h>
#include <s32mem.h>
#include "txtviewerdoc.h"
const TInt KMemoryStoreBuffSize = 127;



// ---------------------------------------------------------
// CTxtViewerServiceSession
// ---------------------------------------------------------
//
EXPORT_C CTxtViewerServiceSession::CTxtViewerServiceSession()
: iDoc(CEikonEnv::Static()->EikAppUi()->Document())
	{	
	}

// ---------------------------------------------------------
// CTxtViewerServiceSession
// ---------------------------------------------------------
//
CTxtViewerServiceSession::~CTxtViewerServiceSession()
	{
	}

// ---------------------------------------------------------
// CTxtViewerServiceSession::CreateL
// ---------------------------------------------------------
//
void CTxtViewerServiceSession::CreateL()
	{
	CApaAppServiceBase::CreateL();		
	}
	
// ---------------------------------------------------------
// CTxtViewerServiceSession::ServiceL
// ---------------------------------------------------------
//
void CTxtViewerServiceSession::ServiceL(const RMessage2& aMessage)
	{
	switch (aMessage.Function())
		{
		case ETxtViewerServiceCmdOpen:
			OpenL(aMessage);
			break;


		default:
			CApaAppServiceBase::ServiceL(aMessage);
			break;
		}		
	}
	
// ---------------------------------------------------------
// CTxtViewerServiceSession::ServiceError
// ---------------------------------------------------------
//
void CTxtViewerServiceSession::ServiceError(const RMessage2& aMessage,TInt aError)
	{
	CApaAppServiceBase::ServiceError(aMessage, aError);		
	}
	
// ---------------------------------------------------------
// CTxtViewerServiceSession::OpenL
// ---------------------------------------------------------
//
void CTxtViewerServiceSession::OpenL( const RMessage2& aMessage )
	{
	
	TEditorParameters params;
	params.iEntry = aMessage.Int0( );
	params.iOpenedForEditing= aMessage.Int1( );
	CTxtViewerDocument* doc = static_cast<CTxtViewerDocument*>(iDoc);
	 
   	doc->SetId(params.iEntry);
   	doc->SetOpenedForEditing(params.iOpenedForEditing);
   
   	doc->SetMessage(aMessage);
	doc->InitializeL();
	aMessage.Complete(KErrNone);
   
	}
