/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef INTERNETEMAILAPP_H
#define INTERNETEMAILAPP_H

// INCLUDES
#include <aknapp.h>

// CONSTANTS
// UID of the application
const TUid KUidInternetEmail = { 0x101FF1C8 };

// CLASS DECLARATION

/**
* CInternetEmailApp application class.
* Provides factory to create concrete document object.
* 
*/
class CInternetEmailApp : public CAknApplication
    {
    
    public: // Functions from base classes
        /**
        * From CApaApplication, overridden to enable INI file support.
        * @return A pointer to the dictionary store
        */
    CDictionaryStore* OpenIniFileLC(RFs& aFs) const;
    private:

        /**
        * From CApaApplication, creates CInternetEmailDocument document object.
        * @return A pointer to the created document object.
        */
        CApaDocument* CreateDocumentL();
        
        /**
        * From CApaApplication, returns application's UID (KUidInternetEmail).
        * @return The value of KUidInternetEmail.
        */
        TUid AppDllUid() const;
    };

#endif

// End of File

