/*
 * Copyright  2008 Nokia Corporation.
 */

// INCLUDE FILES
#include <eikstart.h>
#include "InternetEmailApp.h"
#include "InternetEmailDocument.h"

// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------
// CInternetEmailApp::AppDllUid()
// Returns application UID
// ---------------------------------------------------------
//
TUid CInternetEmailApp::AppDllUid() const
    {
    return KUidInternetEmail;
    }

// ---------------------------------------------------------
// CDictionaryStore* CInternetEmailApp::OpenIniFileLC(RFs& aFs) const
// overrides CAknApplication::OpenIniFileLC to enable INI file support
// ---------------------------------------------------------
//
CDictionaryStore* CInternetEmailApp::OpenIniFileLC(RFs& aFs) const
{
    return CEikApplication::OpenIniFileLC(aFs);
}
   
// ---------------------------------------------------------
// CInternetEmailApp::CreateDocumentL()
// Creates CInternetEmailDocument object
// ---------------------------------------------------------
//
CApaDocument* CInternetEmailApp::CreateDocumentL()
    {
    return CInternetEmailDocument::NewL( *this );
    }


// ================= OTHER EXPORTED FUNCTIONS ==============
//
// ---------------------------------------------------------
// NewApplication() 
// Constructs CInternetEmailApp
// Returns: created application object
// ---------------------------------------------------------
//
EXPORT_C CApaApplication* NewApplication()
    {
    return new CInternetEmailApp;
    }

    
// ---------------------------------------------------------
// E32Main() 
// Entry point function for EPOC Application
// Returns: EikStart::RunApplication: NewApplication
// ---------------------------------------------------------
//
GLDEF_C TInt E32Main()
    {
    return EikStart::RunApplication( NewApplication );
    }

// End of File  

