// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef __PROCESSSERVER_H__
#define __PROCESSSERVER_H__

#include <e32base.h>
#include <e32std.h>
#include "shutdownserver.h"
#include "processclientserver.h"
#include "driver1.h"

class CAsyncHandler; 
/**
	Interface for process server.
*/		
class CProcessServer : public CServer2
	{
public:
	/**
	Enumeration of states of driver.
	*/
	enum TDriverState
		{
		EStateUnknown,
		EDriverLoaded,
		ELogicalChannelOpened,
		ESendingData,
		ELogicalChannelClosed,
		EDriverUnloaded
		};
	/**
	 Two phase constructor.
	 */
	static void NewLC();
	/**
	 Destructor,
	 The device driver will be unloaded when the server destructor is called.
	 */
	~CProcessServer();
	/**
	 Creates a server-side session object.
	 @see CServer2::NewSessionL().
	 */
	CSession2* NewSessionL(const TVersion& aVersion,const RMessage2& aMessage) const;
	/**
	 Increases reference count and cancels shutdown timer.  
	 This function is called when a new session is created.
	 */
	void IncrementRefCount();
	/**
	 Decreases reference count and starts shutdown timer.
	 This function is called when a session is destroyed.
	 */
	void DecrementRefCount();
	/**
	 Loads the device, including sample PDD and LDD.
	 */
	TInt LoadDevice();
	/**
	 Unloads the device, including sample LDD and PDD.
	 */
	TInt UnloadDevice();
	/**
 	 Opens device's logical channel.
 	*/
	TInt OpenLogicalChannel();
	/**
 	 Closes device's logical channel.
 	*/
	void CloseLogicalChannel();
	/**
 	 Sends data to device asynchronously.
 	*/
	TInt SendDataToDevice(TRequestStatus& aStatus, const TDesC8& aData);
	/**
 	 Cancels send data operation.
 	*/
	void CancelSendData();
	/**
	 Updates device state.
	 */
	void UpdateDriverState(TDriverState aState);
	
private:
	CProcessServer();
	void ConstructL();

private:
	TInt 					iRefCount;
	CDelayServerShutDown*  	iDelayProcessServerShutDown;
	RDriver1 				iDriver;
	TDriverState			iDriverState;
	};
	


#endif
