/*
* ==============================================================================
*  Name        : Compress.c
*  Part of     : OpenCLibz
*  Interface   : 
*  Description : 
*  Version     : 
*
*  Copyright (c) 2007 Nokia Corporation.
*  This material, including documentation and any related 
*  computer programs, is protected by copyright controlled by 
*  Nokia Corporation.
* ==============================================================================
*/



/** @file Compress.c
* In this file I use libz api's to compress file and string
* Here i make use of libz api which can write to compressed files.
* Also there is memory mapping techniqe used though 
* mmap api of libc which can be used if buffer is large enogh.
*/ 


#include "OpenCLibzheader.h"
#include <limits.h>

//
// GzCompress
// Compress the input file "in" and generates "out" file
//
void GzCompress(FILE   *in,gzFile out)
{
    static char buf[BUFLEN];
    int len;
    

#ifdef USE_MMAP
    /* Try first compressing with mmap. If mmap fails 
     use the normal fread loop.
     */
    if (GzCompressMmap(in, out) == Z_OK) return;
#endif
    for (;;) 
    {
        len = (int)fread(buf, 1, sizeof(buf), in);
        if (len < 0) 
        Error("error reading the file \n");
    
        if (len == 0) break;

        if (gzwrite(out, buf, (unsigned)len) != len) 
        Error("error writing to the file \n");;
        
    }
    fclose(in);
    
    if (gzclose(out) != Z_OK) // libz api to close a compressed file 
    Error("failed gzclose");
}






#ifdef USE_MMAP 

//
// GzCompressMmap
// Try compressing the input file at once using mmap. Return Z_OK 
// If success, otherwise it returns Z_ERRNO .
// 
int GzCompressMmap(FILE   * in,gzFile out)
{
    int len;
    int err;
    int ifd = fileno(in);
    caddr_t buf;    /* mmap'ed buffer for the entire input file */
    off_t buf_len;  /* length of the input file */
    struct stat sb;

    /* Determine the size of the file, needed for mmap: */
    
    if (fstat(ifd, &sb) < 0) 
    return Z_ERRNO;
    
    buf_len = sb.st_size;
    
    if (buf_len <= 0) 
    return Z_ERRNO;

    /* Now do the actual mmap: */
    
    buf =(char*) mmap((caddr_t) 0, buf_len, PROT_READ, MAP_SHARED, ifd, (off_t)0);
    
    //mmap is an openc api 
    
    if (buf == (caddr_t)(-1)) 
    return Z_ERRNO;

    /* Compress the whole file at once: */
    len = gzwrite(out, (char *)buf, (unsigned)buf_len);

    if (len != (int)buf_len) 
    Error(gzerror(out, &err));

    munmap(buf, buf_len);
    fclose(in);
    if (gzclose(out) != Z_OK) // libz api to close a compressed file 
    Error("failed gzclose");
    
    return Z_OK;
}
#endif /* USE_MMAP */





//
// -----------------------------------------------------------------------------
// FileCompress
// Compresses the file using mode value
// -----------------------------------------------------------------------------
//
void FileCompress(char  * file,char  * mode)
{
    static char outfile[MAX_NAME_LEN];
    FILE  *in;
    gzFile out;
	char choice[3];

    strcpy(outfile, file);
    strcat(outfile, GZ_SUFFIX);

    in = fopen(file, "rb");
    if (in == NULL) 
    {    
    Error("file not found ...try again \n");
    }
    out = gzopen(outfile, mode);
    if (out == NULL) 
    {       
    Error("error opening outfile\n ");        
    }
    GzCompress(in, out);
   
    
    printf("do you want to delete the original file (y /n) \n");
    
    scanf("%s",choice);
    /*I am using scanf("%s",...) because of some problem in getchar() as 
    well as scanf("%c"...) .   I have reported the bug */
    
    if(choice[0] == 'y')
    unlink(file);
    
    printf(" Congrats .... compression done ...u can find .gz file in the same directory as of the source file\n");
}

//
// -----------------------------------------------------------------------------
// StringCompress
// Compresses the string
// This function compresses the string entered by the user and shows the
// compressed string and then decompressess it 
// Actually This function will show the content on the screen and demonstarte 
// how strings can be compressed
// -----------------------------------------------------------------------------
//

void StringCompress()
{
    Byte *compr, *uncompr;
    uLong len,comprLen,uncomprLen;
    char *hello;
     
    hello = (char *)malloc(100*sizeof(char));
  
    printf("enter the string(maximum 100 characters) to compress....\n");



    scanf("%s",hello); //accepts the string from the user
    len = (uLong)strlen(hello)+1;
    comprLen = 10 * len; 
    uncomprLen = comprLen;
    
    //memory allocation
    compr    = (Byte*)calloc((uInt)comprLen, 1);  
    uncompr  = (Byte*)calloc((uInt)uncomprLen, 1);
    	 	
    	 	
    	 	
    //compress is one of the api of libz library used to compress data
    
    compress(compr, &comprLen, (const Bytef*)hello, len);

    strcpy((char*)uncompr, "garbage"); //initialization
    
    printf("compressed string is : %s\n\n", (char *)compr);

    //uncompress is one of the api of libz library used to uncompress data
    
    uncompress(uncompr, &uncomprLen, compr, comprLen);

   
    printf("press enter to uncompress it\n");
    
    getchar();
    getchar();
    
    if (strcmp((char*)uncompr, hello)) 
    {
        Error("bad uncompress\n");  
        free(compr);
        free(uncompr);        
    }
    else 
    {
        printf("uncompressed string is : %s\n", (char *)uncompr);
        free(compr);
        free(uncompr);
    }
    
}

/*  End of File */
