// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the definition of the CProducer class.
//



/**
 @file
*/
#ifndef __PRODUCER_H__
#define __PRODUCER_H__

#include "globals.h"
#include "queue.h"

/**
This class owns the producer thread.
It provides an interface to insert tokens into the CQueue::iArray queue.
@see CQueue.
@see CPeriodic.
*/
class CProducer : public CBase
	{
public:
	static CProducer* NewL(CConsoleBase* aConsole,CQueue* aTokens);
	void ConstructL(CConsoleBase* aConsole,CQueue* aTokens);
	static TInt ProdThreadFunc(TAny* aPtr);
	void ResumeProd();
	void Display();
	void Produce();
	~CProducer();
	static TInt InsertFunction(TAny* aPtr);
private:
	CProducer();
private:
	/**
	The pointer to a CQueue object.
	Both CProducer and the CConsumer classes share the same object of the CQueue class.
	@see CConsumer::iQueue.
	*/
	CQueue* iQueue;
	/**
	The producer thread.
	It is invoked periodically by the CProducer::iPeriodicProd object, which is an instance of the CPeriodic class.
	*/
	RThread iProdThread;
	/**
	The CPeriodic object.
	It runs the producer thread (CProducer::iProdThread) at regular intervals.
	@see CProducer::ConstructL().
	*/
	CPeriodic* iPeriodicProd;
	/**
	The user console.
	*/
	CConsoleBase* iConsole;
	};

#endif
