// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the E32Main() function, which executes the example.
// The example demonstrates the use of local condition variable IPC mechanism. The threads created in the process use this condition variable to co-operate with each other.
// The example performs the following tasks:
// - create an object of the CQueue class, which in turn crates a queue of integer tokens
// - create an object of the CProducer class, which in turn creates the producer thread
// - create an object of the CConsumer class, which in turn creates the consumer thread
// - create an object of the CUserInterface class ,which accepts asynchronous key press events from the console.
// The CUserInterface class provides an interface for the user to interact with the threads created in the example.
// The CQueue::iCondVar is the local condition varaibale that is used by the two threads to co-operate with each other.
//



/**
 @file
 @see CQueue.
 @see CProducer.
 @see CConsumer.
 @see CUserInterface.
*/

#include "globals.h"
#include "queue.h"
#include "producer.h"
#include "consumer.h"
#include "userinterface.h"

LOCAL_D CConsoleBase* console;
LOCAL_C void DoExampleL();
LOCAL_C void callExampleL();

LOCAL_C void DoExampleL()
	{
	CActiveScheduler* scheduler = new (ELeave) CActiveScheduler();
	CleanupStack::PushL(scheduler);
	CActiveScheduler::Install(scheduler);

	// Create an object of the CQueue class.
	CQueue* tokens = CQueue::NewL();
	CleanupStack::PushL(tokens);

	// Print the KTextInvokeProducer string and wait for a key press.
	_LIT(KTextInvokeProducer,"Creating and starting the Producer Thread...[This produces a token every two seconds]\n");
	console->Printf(KTextInvokeProducer);
	_LIT(KTxtPressAnyKeyToContinue,"[press any key to continue]\n");
	console->Printf(KTxtPressAnyKeyToContinue);
	console->Getch();
	// Create an object of the CProducer class.
	CProducer* prod = CProducer::NewL(console,tokens);
	CleanupStack::PushL(prod);

	// Print the KTextInvokeConsumer string and wait for a key press.
	_LIT(KTextInvokeConsumer,"Creating and starting the Consumer Thread...[This consumes a token every second]\n");
	console->Printf(KTextInvokeConsumer);
	console->Printf(KTxtPressAnyKeyToContinue);
	console->Getch();

	// Create an object of the CConsumer class.
	CConsumer* cons = CConsumer::NewL(console,tokens);
	CleanupStack::PushL(cons);

	// Create an object of the CUserInterface class.
	// This handles key press requests from the console.
	CUserInterface* ui = CUserInterface::NewL(console,prod);
	CleanupStack::PushL(ui);
	
	_LIT(KTextStartAS,"Starting the active scheduler...\n");
	console->Printf(KTextStartAS);
	// Issue an asynchronous read request.
	ui->ReadFunc();
	// Start the active scheduler.
	CActiveScheduler::Start();

	CleanupStack::PopAndDestroy(5,scheduler);
	}

GLDEF_C TInt E32Main()
    {
	__UHEAP_MARK;
	CTrapCleanup* cleanup=CTrapCleanup::New();
	TRAPD(error,callExampleL());
	delete cleanup;
	__ASSERT_ALWAYS(!error,User::Panic(KTxtEPOC32EX,error));
	__UHEAP_MARKEND;
	return 0;
    }

LOCAL_C void callExampleL()
    {
	console=Console::NewL(KTxtExampleCode,TSize(KConsFullScreen,KConsFullScreen));
	CleanupStack::PushL(console);
	TRAPD(error,DoExampleL());
	if (error)
		console->Printf(KFormatFailed, error);
	else
		console->Printf(KTxtOK);
	console->Printf(KTxtPressAnyKey);
	console->Getch();
	CleanupStack::PopAndDestroy();
    }
