// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the definition of the CAdder class.
//



/**
 @file
*/
#ifndef __ADDER_H__
#define __ADDER_H__

#include "longnumber.h"
/**
This class stores an object of the CLongNumber class.
It has methods to calculate the sum of all digits of the number
represented by the iLongNumber object.
*/
class CAdder : public CBase
	{
public:
	static CAdder* NewL(CLongNumber* aNum1);
	~CAdder();
	TInt Add();
private:
	CAdder(CLongNumber* aNum1);	
private:
	/**
	The long number.
	*/
	CLongNumber* iLongNumber;
	/**
	Stores the result of addition of all digits of the long number.
	*/
	TInt iResult;
	};

#endif

