// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains definition of functions defined in the CAdder class.
//



/**
 @file
*/

#include "adder.h"

/**
Creates an object of the CAdder class.
@param aLongNumber A pointer to the object of the CLongNumber class.
@return A pointer to the object of the CAdder class.
*/
CAdder* CAdder::NewL(CLongNumber* aLongNumber)
	{
	CAdder* self = new (ELeave) CAdder(aLongNumber);
	return self;
	}

/**
Constructor.
*/
CAdder::CAdder(CLongNumber* aLongNumber):iLongNumber(aLongNumber)
	{
	}

/**
Performs the addition of all digits of the iLongNumber object.
@return The sum of all digits of the iLongNumber object.
*/
TInt CAdder::Add()
	{
	// Set the iterator to the start of the list.
	iLongNumber->InitializeIter();

	// Initialize sum to 0.
	TInt num;
	TInt sum = 0;

	// Iterate the list.
	// The iterator is pointing to a valid node.
	// Get the digit represented by this node.
	while(iLongNumber->GetNumber(num))
		{
		// Update the sum.
		sum += num;
		// Go to the next digit.
		iLongNumber->Slide();
		}

	return sum;
	}

/**
Destructor.
*/
CAdder::~CAdder()
	{
	}

