// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the E32Main() function, which executes the example.
// The example demonstrates the use of the TSglQue class, which represents
// a singly linked list.
// The user enters a long number, which is stored as linked list of digits
// of the number. The user can edit this number by adding digits to the list
// or removing digits from the list.
// The example displays the sum of all digits of this number on the console.
//



/**
 @file
*/

#include "adder.h"

LOCAL_D CConsoleBase* console;

LOCAL_C void DoStartL();
LOCAL_C void CallExampleL();

LOCAL_C void DoStartL()
	{
	// Create and install the active scheduler.
	CActiveScheduler* scheduler = new (ELeave) CActiveScheduler();
	CleanupStack::PushL(scheduler);
	CActiveScheduler::Install(scheduler);

	// Create an object of the CLongNumber class.
	CLongNumber* number = CLongNumber::NewL(console);
	CleanupStack::PushL(number);

	// Read the number from the user.
	_LIT(KTextEnterNumber,"Singly linked list example.\nEnter the digits of a number...\n");
	console->Printf(KTextEnterNumber);
	// Generate an asynchronous read request.
	number->ReadNumber();

	// Start the active scheduler.
	CActiveScheduler::Start();

	// Create an object of the CAdder class.
	CAdder* adder = CAdder::NewL(number);
	// Add all the digits of the number and print the sum.
	_LIT(KTextSum,"Sum of all digits of the number : %d\n");
	console->Printf(KTextSum,adder->Add());
	delete adder;

	// Destroy the objects in the cleanup stack.
	CleanupStack::PopAndDestroy(2,scheduler); // number, scheduler.
	}

GLDEF_C TInt E32Main() // main function called by E32
    {
	__UHEAP_MARK;
	CTrapCleanup* cleanup=CTrapCleanup::New(); // get clean-up stack
	TRAPD(error, CallExampleL()); // more initialization, then do example
	delete cleanup; // destroy clean-up stack
	__ASSERT_ALWAYS(!error, User::Panic(KTxtEPOC32EX, error));
	__UHEAP_MARKEND;
	return 0; // and return
    }

LOCAL_C void CallExampleL() // initialize and call example code under cleanup stack
    {
	console=Console::NewL(KTxtExampleCode, TSize(KConsFullScreen, KConsFullScreen));
	CleanupStack::PushL(console);
	TRAPD(error, DoStartL()); // perform example function
	if (error)
		console->Printf(KFormatFailed, error);
	else
		console->Printf(KTxtOK);
	console->Printf(KTextPressAnyKey);
	console->Getch(); // get and ignore character
	CleanupStack::PopAndDestroy(); // close console
    }
