// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains various constants and function prototypes for localeupdate.cpp.
//



/**
 @file
*/
#ifndef __LOCALEUPDATE_H__
#define __LOCALEUPDATE_H__

#include <e32base.h>
#include <collate.h>
#include <e32std.h>
#include <e32cons.h>
const TInt KLength = 20;

/**
This class stores the locale settings of a locale DLL.
It also defines functions to display these settings.
@see TExtendedLocale.
@see TLocale.
*/
class CLocaleSettings : public CBase
	{
public:
	~CLocaleSettings();
	static CLocaleSettings* NewL(TDesC16& aLocaleDLLName, CConsoleBase* aConsole);
	void DisplayLocaleSettings();

private:
	CLocaleSettings();
	void ConstructL(TDesC16& aLocaleDLLName, CConsoleBase* aConsole);
private:
	/**
	An object of the extended locale class.
	*/
	TExtendedLocale iExtendedLocale;
	/**
	An object of the TLocale class.
	It gets the system's locale settings.
	*/
	TLocale* iLocale;
	/**
	It stores the enumeration of type TDay that indicates the first day of the week of the locale.
	*/
	TDay iStartOfWeek;
	/**
	The working days mask for the locale.
	A bit mask of seven bits indicating (by being set) which days are workdays.
	The least significant bit corresponds to Monday, the next bit to Tuesday and so on.
	*/
	TUint iWorkingDaysMask;
	/**
	The collation method for the locale.
	*/
	TCollationMethod iCollationMethod;
	/**
	The country code for the locale.
	*/
	TInt iCountryCode;
	/**
	The date format for the locale.
	*/
	TDateFormat iDateFormat;
	/**
	The time format for the locale.
	*/
	TTimeFormat iTimeFormat;
	/**
	The character that represents the thousands separator for the locale.
	*/
	TChar iThousandsSeparator;
	/**
	The character that represents the decimal separator for the locale.
	*/
	TChar iDecimalSeparator;
	/**
	The general units of measurement.
	*/
	TUnitsFormat iUnitsFormat;
	/**
	The user console.
	*/
	CConsoleBase* iConsole;
	/**
	The descriptor to store the name of the locale DLL.
	*/
	TBuf<KLength> iLocaleDLLName;
	/**
	The offset of the time zone from UTC.
	*/
	TTimeIntervalSeconds iUTCOffset;
	};

_LIT(KTextPressAnyKey, "[press any key]\r\n");
_LIT(KTextNewLine, "\r\n");
_LIT(KTextChar, "%c");
_LIT(KTxtEPOC32EX, "EXAMPLES");
_LIT(KTxtExampleCode, "Symbian platform locale Example Code");
_LIT(KTxtOK, "ok");
_LIT(KFormatFailed, "failed: leave code=%d");

#endif

