// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the definition of the CUserInterface class.
//



/**
 @file
*/
#ifndef __USERINTERFACE_H__
#define __USERINTERFACE_H__

#include "timerentry.h"

/**
This class processes key press events from the console.
The example prints a menu and waits for the user to select an option from the menu.
The CUserInterface::RunL() function handles the asynchronous key press event.
*/
class CUserInterface : public CActive
	{
public:
	static CUserInterface* NewL(CConsoleBase* aConsole,CTimerEntry* aTimerEntry);
	void Initialize(CConsoleBase* aConsole,CTimerEntry* aTimerEntry);
	void RunL();
	void DoCancel();
	~CUserInterface();
	void ReadFunc();
private:
	CUserInterface();
private:
	/**
	The user console.
	*/
	CConsoleBase* iConsole;
	/**
	A pointer to an object of the CProducer class. This class owns the producer thread.
	@see CProducer.
	*/
	CTimerEntry* iTimerEntry;
	};

#endif
