// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains CHashTableExample class.
//



/**
 @file
*/
#ifndef __HASHTABLEEXAMPLE_H__
#define __HASHTABLEEXAMPLE_H__

// Symbian platform includes
#include <e32cons.h>

// Literals
_LIT(KTitle, "Hash Table Example" );
_LIT(KFailed, "\nFailed to complete");
_LIT(KPressAKeyMsg, "\n\nPress any key to step through the example\n");
_LIT(KExitMsg, "\nPress any key to exit the application ");
_LIT(KPressAKey, "\nPress any key to continue\n");
_LIT(KWelcome, "\n    Welcome to the hash table example application");
_LIT(KConstruct, "   Construction:  \n");
_LIT(KOperation, "   Operation:   \n");
_LIT(KAnd," And ");

_LIT(KHashSet, "\n HASH SET:  \n");
_LIT(KConstructDefaultHashSet, "\t Construction of hash set using default hash and identity function: successful\n");
_LIT(KConstructOwnHashSet, "\t Construction of hash set using custom hash and identity function: successful\n");
_LIT(KInsertItemsToHashSet, "\t Insertion of items to hash set: successful\n");
_LIT(KItemPresentInHashSet, "\t Item is present in hash set\n");
_LIT(KItemNotPresentInHashSet, "\t Item is not present in hash set\n");
_LIT(KIterateItemsFromHashSet, "\t Iteration of items from hash set: successful\n");
_LIT(KRemoveItemsFromHashSet, "\t Removal of items from hash set: successful\n");

_LIT(KPtrHashSet, "\n HASH SET OF POINTERS:  \n");
_LIT(KConstructDefaultPtrHashSet, "\t Construction of hash set of pointers using default hash and identity function: successful\n");
_LIT(KConstructOwnPtrHashSet, "\t Construction of hash set of pointers using custom hash and identity function: successful\n");
_LIT(KInsertItemsToPtrHashSet, "\t Insertion of items to hash set of pointers: successful\n");
_LIT(KItemPresentInPtrHashSet, "\t Item is present in the hash set of pointers\n");
_LIT(KItemNotPresentInPtrHashSet, "\t Item is not present in hash set of pointers\n");
_LIT(KIterateItemsFromPtrHashSet, "\t Iteration of items from hash set of pointers: successful\n");
_LIT(KRemoveItemsFromPtrHashSet, "\t Removal of items from hash set of pointers: successful\n");
_LIT(KFindItem,"eleven");
_LIT(KRemoveItem,"twenty");


_LIT(KHashMap, "\n HASH MAP:  \n");
_LIT(KConstructDeafultHashMap, "\t Construction of hash map using default hash and identity function: successful\n");
_LIT(KConstructOwnHashMap, "\t Construction of hash map using custom hash and identity function: successful\n");
_LIT(KInsertItemsToHashMap, "\t Insertion of items to hash map: successful\n");
_LIT(KItemPresentInHashMap, "\t Item is present in hash map\n");
_LIT(KItemNotPresentInHashMap, "\t Item is not present in hash map\n");
_LIT(KIterateItemsFromHashMap, "\t Iteration of items from hash map: successful\n");
_LIT(KRemoveItemsFromHashMap, "\t Removal of items from hash map: successful\n");

_LIT(KPtrHashMap, "\n HASH MAP OF POINTERS:  \n");
_LIT(KConstructDeafultPtrHashMap, "\t Construction of hash map of pointers using default hash and identity function: successful\n");
_LIT(KConstructOwnPtrHashMap, "\t Construction of hash map of pointers using custom hash and identity function: successful\n");
_LIT(KInsertItemsToPtrHashMap, "\t Insertion of items to hash map of pointers: successful\n");
_LIT(KItemPresentInPtrHashMap, "\t Item is present in hash map of pointers\n");
_LIT(KItemNotPresentInPtrHashMap, "\t Item is not present in hash map of pointers\n");
_LIT(KIterateItemsFromPtrHashMap, "\t Iteration of items from hash map of pointers: successful\n");
_LIT(KRemoveItemsFromPtrHashMap, "\t Removal of items from hash map of pointers: successful\n");

/**
Demonstrates some uses of the Symbian platform hash table APIs of the User Library component.

The class demonstrates how to construct and operate a hash set, a hash set of pointers, a hash map and a hash map of pointers.
- Construction of these includes
	- using the default hash and identity functions for integers and for descriptors
	- providing custom hash and identity functions
- Operation of these includes
	- inserting items
	- finding items
	- removing items
	- iterating through items
	- closing and cleanup
*/
class CHashTableExample: public CBase
	{
	public:
	static CHashTableExample* NewL();
	~CHashTableExample();
 
	void ConstructDefaultHashSet();
	void ConstructOwnHashSet();
	void OperationsToHashSetL();
	void ConstructDefaultPtrHashSet();
	void ConstructOwnPtrHashSet();
	void OperationsToPtrHashSetL();
	void ConstructDefaultHashMap();
	void ConstructOwnHashMap();
	void OperationsToHashMapL();
	void ConstructDefaultPtrHashMap();
	void ConstructOwnPtrHashMap();
	void OperationsToPtrHashMapL();
  
	private:
	CHashTableExample();
	void ConstructL();

	private:
	/** Pointer to console interface */
	CConsoleBase* iConsole;
	
	/** Array used to hold example data to store in the hash objects */
	RPointerArray<TDesC16> iPointerArray;
	};

#endif //__HASHTABLEEXAMPLE_H__



