/* ====================================================================
 * File: handlerAppUi.h
 * Created: 09/27/05
 * Author: 
 * Copyright (c): , All rights reserved
 * ==================================================================== */

#ifndef __HANDLER_APPUI_H__
#define __HANDLER_APPUI_H__

#include <aknappui.h>
#include <DocumentHandler.h>

// Forward reference
class CHandlerAppView;

/*! 
  @class CHandlerAppUi
  
  @discussion An instance of class CHandlerAppUi is the UserInterface part of the AVKON
  application framework for the handler example application
  */
class CHandlerAppUi : public CAknAppUi                                 
    {
    public:
    /*!
      @function ConstructL
      
      @discussion Perform the second phase construction of a CHandlerAppUi object
      this needs to be public due to the way the framework constructs the AppUi 
      */
        void ConstructL();

    /*!
      @function CHandlerAppUi
      
      @discussion Perform the first phase of two phase construction.
      This needs to be public due to the way the framework constructs the AppUi 
      */
        CHandlerAppUi();

    /*!
      @function ~CHandlerAppUi
      
      @discussion Destroy the object and release all memory objects
      */
        ~CHandlerAppUi();

        void SetFileData(TFileName& aFileName, TDes8& aData);

    public: // from CAknAppUi

        /**
        * From CAknAppUi, handles file change.
        * @param aFileName New file to be opened.
        */
    	void OpenFileL( const TDesC& aFileName );  

        /*!
        * See CAknAppUi
        */
        void HandleCommandL(TInt aCommand);
        
        /*!
        * See CAknAppUi
        */
        void HandleResourceChangeL(TInt aType);

        /*!
        * See CAknAppUi
        */
        TBool ProcessCommandParametersL(TApaCommand aCommand,TFileName& aDocumentName);

        /*!
        * See CAknAppUi
        */
        TBool ProcessCommandParametersL(TApaCommand aCommand,TFileName& aDocumentName,const TDesC8& aTail);
        
    private:
        
        /**!
        * Returns true if the application is embedded
        */
        TBool IsEmbedded();
        
    private:

        // The application view
        CHandlerAppView* iAppView;

    };


#endif // __HANDLER_APPUI_H__

