/* ====================================================================
 * File: handlerDocument.h
 * Created: 09/27/05
 * Author: 
 * Copyright (c): , All rights reserved
 * ==================================================================== */

#ifndef __HANDLER_DOCUMENT_H__
#define __HANDLER_DOCUMENT_H__


#include <akndoc.h>

// Forward references
class CHandlerAppUi;
class CEikApplication;


/*! 
  @class CHandlerDocument
  
  @discussion An instance of class CHandlerDocument is the Document part of the AVKON
  application framework for the handler example application
  */
class CHandlerDocument : public CAknDocument
    {
public:

/*!
  @function NewL
  
  @discussion Construct a CHandlerDocument for the AVKON application aApp 
  using two phase construction, and return a pointer to the created object
  @param aApp application creating this document
  @result a pointer to the created instance of CHandlerDocument
  */
    static CHandlerDocument* NewL(CEikApplication& aApp);

/*!
  @function NewLC
  
  @discussion Construct a CHandlerDocument for the AVKON application aApp 
  using two phase construction, and return a pointer to the created object
  @param aApp application creating this document
  @result a pointer to the created instance of CHandlerDocument
  */
    static CHandlerDocument* NewLC(CEikApplication& aApp);

/*!
  @function ~CHandlerDocument
  
  @discussion Destroy the object and release all memory objects
  */
    ~CHandlerDocument();

public: // from CAknDocument
/*!
  @function CreateAppUiL 
  
  @discussion Create a CHandlerAppUi object and return a pointer to it
  @result a pointer to the created instance of the AppUi created
  */
    CEikAppUi* CreateAppUiL();
    
public:	// from CEikDocument
	
	/**
    * From @c CEikDocument. Opens a file.
    * @param aDoOpen Open an existing file if @c ETrue, 
    * otherwise create a new file. Not used.
    * @param aFilename The file to open or create. Not used.
    * @param aFs File server session to use. Not used.
    * @return Pointer to file store object.
    */
    CFileStore* OpenFileL(TBool aDoOpen,const TDesC& aFilename,RFs& aFs);    

    void OpenFileL(CFileStore*& aFileStore, RFile& aFile);

private:

/*!
  @function ConstructL
  
  @discussion Perform the second phase construction of a CHandlerDocument object
  */
    void ConstructL();
    

/*!
  @function CHandlerDocument
  
  @discussion Perform the first phase of two phase construction 
  @param aApp application creating this document
  */
    CHandlerDocument(CEikApplication& aApp);
    
private:
    CEikAppUi* iAppUi;
    
    TFileName iFileName;
    };


#endif // __HANDLER_DOCUMENT_H__
