/* ====================================================================
 * File: handlerAppUi.cpp
 * Created: 09/27/05
 * Author: 
 * Copyright (c):  All rights reserved
 * ==================================================================== */

#include <avkon.hrh>
#include <aknnotewrappers.h> 

#include <utf.h>

#include "handler.pan"
#include "handlerAppUi.h"
#include "handlerAppView.h"
#include "handler.hrh"
#include "handlerDocument.h"

#include <DocumentHandler.h>
#include <eikenv.h> 
#include <eikappui.h>
#include <eikapp.h>
#include <APPARC.H>
#include <eikproc.H>
#include <apmstd.h> //TDAtatype, Link against: apmime.lib 

#include <handler.rsg>
#include <eikbtgpc.h> //CEikButtonGroupContainer

#define KEnableSkinFlag 0x1000
#define KLayoutAwareFlag 0x08

void CHandlerAppUi::ConstructL()
    {
    #ifdef __SERIES60_3X__
	    BaseConstructL(EAknEnableSkin);
	#else
	    BaseConstructL(KEnableSkinFlag | KLayoutAwareFlag);
	#endif

    iAppView = CHandlerAppView::NewL(ClientRect());    

    if (IsEmbedded())
        {
        //If the handler application is launched as embedded 
        //then set the right softkey to "Back"
        CEikButtonGroupContainer * iCba = CEikButtonGroupContainer::Current();
    	if( iCba) 
        	{
    		iCba->SetCommandSetL( R_AVKON_SOFTKEYS_OPTIONS_BACK );
    		iCba->DrawNow(); 
        	}        
        }

    AddToStackL(iAppView);
    }

CHandlerAppUi::CHandlerAppUi()                              
    {
	// no implementation required
    }

CHandlerAppUi::~CHandlerAppUi()
    {
    if (iAppView)
        {
        RemoveFromStack(iAppView);
        delete iAppView;
        iAppView = NULL;
        }
        
    //This only works in 1st and 2nd edition
    if( iDoorObserver )
        {        
        iDoorObserver->NotifyExit( MApaEmbeddedDocObserver::ENoChanges );            
        }
        
    }

// handle any menu commands
void CHandlerAppUi::HandleCommandL(TInt aCommand)
    {
    switch(aCommand)
        {
        case EEikCmdExit:
        case EAknSoftkeyBack:
            //The application was embedded, now just closes this and
            //goes back to the launcher application
            
        case EAknSoftkeyExit:
            //Closes the possible launcher app also if launched embedded
            //In the embedded case the Exit was choosen from the options
            //menu
            if( iDoorObserver )
                {
                SaveL();
                }
            Exit();
            break;

        default:
            Panic(EhandlerBasicUi);
            break;
        }
    }

void CHandlerAppUi::SetFileData(TFileName& aFileName, TDes8& aData)
    {
    if (iAppView)
        {
        iAppView->SetFileData(aFileName,aData);
        }
    }

void CHandlerAppUi::HandleResourceChangeL(TInt aType)
	{
	CAknAppUi::HandleResourceChangeL(aType); //call to upper class

    // ADDED FOR SCALABLE UI SUPPORT
    // *****************************
	//if ( aType == KEikDynamicLayoutVariantSwitch )
	//hard coded constant so it can be compiled with first edition
	
	if ( aType == 0x101F8121 )
	    {
	    iAppView->SetRect( ClientRect() );
	    }
	}

TBool CHandlerAppUi::ProcessCommandParametersL(TApaCommand /*aCommand*/,TFileName& /*aDocumentName*/)
    {
    return ETrue;
    }

TBool CHandlerAppUi::ProcessCommandParametersL(TApaCommand /*aCommand*/,TFileName& /*aDocumentName*/,const TDesC8& /*aTail*/)
    {
    //return true here so that document's OpenFileL gets called
    return ETrue;
    }



void CHandlerAppUi::OpenFileL(const TDesC& aFileName)
	{
	// File changed. Open new file with documents OpenFileL method.
	CHandlerDocument* doc = static_cast<CHandlerDocument*> (Document());
	doc->OpenFileL( ETrue, aFileName, iEikonEnv->FsSession() );    
	}
TBool CHandlerAppUi::IsEmbedded()
    {
    #ifdef __SERIES60_3X__
    return iEikonEnv->StartedAsServerApp();
    #else
    return (iDoorObserver != NULL);
    #endif
    }
	
//End of file
