/* ====================================================================
 * File: TestAppAppUi.h
 * Created: 28/06/06 by Forum Nokia
 * Author:
 * Copyright (c): , All rights reserved
 * ==================================================================== */

#ifndef __TESTAPP_APPUI_H__
#define __TESTAPP_APPUI_H__

#include <aknappui.h>

#ifdef __SERIES60_3X__
#include <aknserverapp.h> 
#else
#include <apparc.h>
#endif

// Forward declarations
class CTestAppAppView;
class CDocumentHandler;



/*!
  @class CTestAppAppUi

  @discussion An instance of class CTestAppAppUi is the UserInterface part of the AVKON
  application framework for the TestApp example application
  */

class CTestAppAppUi : public CAknAppUi, public
#ifdef __SERIES60_3X__
MAknServerAppExitObserver
#else
MApaEmbeddedDocObserver
#endif    
    {
    public:
    /*!
      @function ConstructL

      @discussion Perform the second phase construction of a CTestAppAppUi object
      this needs to be public due to the way the framework constructs the AppUi
      */
        void ConstructL();

    /*!
      @function CTestAppAppUi

      @discussion Perform the first phase of two phase construction.
      This needs to be public due to the way the framework constructs the AppUi
      */
        CTestAppAppUi();


    /*!
      @function ~CTestAppAppUi

      @discussion Destroy the object and release all memory objects
      */
        ~CTestAppAppUi();


    public: // from CAknAppUi

        void HandleCommandL(TInt aCommand);

        void HandleResourceChangeL(TInt aType);

    public:
    
        //These callback functions are called when the handler application
        //is closed. The CDocumentHandlers SetExitObserver has to have
        //been called (iDocHandler->SetExitObserver(this);) in order
        //for these functions to be called.
        #ifdef __SERIES60_3X__
        //from MAknServerAppExitObserver
        void HandleServerAppExit (TInt aReason);    
        #else
        //from MApaEmbeddedDocObserver
        void NotifyExit(TExitMode aMode);    
        #endif

    private:
        /**
        * Launches a file using documenthandler.
        * The file is switched in every other function execution.
        * @param aEmbedded Will the handler be launched in embedded mode
        */
        void LaunchFileL(TBool aEmbedded);

        /**
        * If the handler application (aUid) is running, its document file
        * is switched to aFile.
        */
        TBool RefreshDocumentFileL(const TUid& aUid, const TDesC& aFileName );

    private:

        CTestAppAppView* iAppView;

        // a counter for switching the file
        TInt iCount;

        // the document handler
        CDocumentHandler* iDocHandler;

    };


#endif // __TESTAPP_APPUI_H__

