/* ====================================================================
 * File: TestAppAppUi.cpp
 * Created: 28/06/06 by Forum Nokia
 * Author:
 * Copyright (c):  All rights reserved
 * ==================================================================== */

#include <avkon.hrh>
#include <aknnotewrappers.h>

#include "TestApp.pan"
#include "TestAppAppUi.h"
#include "TestAppAppView.h"
#include "TestApp.hrh"

#include <apmstd.h> //TDAtatype, link against: apmime.lib 
#include <DocumentHandler.h>
#include <apgcli.h> //RApaLsSession 

#ifdef __SERIES60_3X__
    _LIT(KTestFile,"c:\\data\\Images\\Pictures\\test.new");
#else
    _LIT(KTestFile,"c:\\nokia\\Images\\Pictures\\test.new");
#endif

#ifdef __SERIES60_3X__
    _LIT(KTestFile2,"c:\\data\\Images\\Pictures\\test2.new");
#else
    _LIT(KTestFile2,"c:\\nokia\\Images\\Pictures\\test2.new");
#endif

void CTestAppAppUi::ConstructL()
    {
    BaseConstructL();

    iAppView = CTestAppAppView::NewL(ClientRect());
    iDocHandler = CDocumentHandler::NewL( CEikonEnv::Static()->Process() );                  

    AddToStackL(iAppView);
    }

CTestAppAppUi::CTestAppAppUi()
    {
    // no implementation required
    }

CTestAppAppUi::~CTestAppAppUi()
    {
    if (iAppView)
        {
        RemoveFromStack(iAppView);
        delete iAppView;
        iAppView = NULL;
        }
    delete iDocHandler;
    }

// handle any menu commands
void CTestAppAppUi::HandleCommandL(TInt aCommand)
    {
    switch(aCommand)
        {
        case EEikCmdExit:
        case EAknSoftkeyExit:
            Exit();
            break;

        case ETestAppCommand1:
            {
            LaunchFileL(EFalse); //standalone
            break;
            }

        case ETestAppCommand2:
            {
            LaunchFileL(ETrue); //embedded
            break;
            }
            break;

        default:
            Panic(ETestAppBasicUi);
            break;
        }
    }

void CTestAppAppUi::LaunchFileL(TBool aEmbedded)
    {
    TFileName path;
    if (iCount++ % 2 == 0)
        {        
        path = KTestFile;
        }
    else
        {
        path = KTestFile2;
        }

    TDataType empty = TDataType();
  
    if( aEmbedded )
        {
        //Set the exit observer so NotifyExit or in 3rd edition
        //HandleServerAppExit will be called
        iDocHandler->SetExitObserver(this);   
        iDocHandler->OpenFileEmbeddedL(path,empty );             
        }        
    else
        {
        iDocHandler->OpenFileL(path,empty );
        
        //If the standalone handler is already running then update the
        //document file
        TUid handlerUid;
        TInt err = KErrNone;
        #ifdef __SERIES60_3X__
            err = iDocHandler->HandlerAppUid(handlerUid);
        #else
            RApaLsSession apaLs;
            User::LeaveIfError( apaLs.Connect() );
            err = apaLs.AppForDocument(path, handlerUid, empty);  
            apaLs.Close();          
        #endif
        
        if( !err )
            {
            RefreshDocumentFileL(handlerUid, path);
            }
        else if( err == KNotInitialized )
            {
            //Handler not initialized
            }
        else
            {
            //Some other error
            }
        
        }

    }

TBool CTestAppAppUi::RefreshDocumentFileL(const TUid& aUid, const TDesC& aFileName )    
    {
    TApaTaskList taskList(iCoeEnv->WsSession());
    TApaTask task = (taskList.FindApp(aUid));

    if (task.Exists())
        {
        //calls AppUi::OpenFileL, requires SwEvent capability      
        User::LeaveIfError(task.SwitchOpenFile(aFileName));
        //task.BringToForeground();
        return ETrue;
        }
    return EFalse;    
    }    
    
void CTestAppAppUi::HandleResourceChangeL(TInt aType)
	{
	CAknAppUi::HandleResourceChangeL(aType); //call to upper class

    // ADDED FOR SCALABLE UI SUPPORT
    // *****************************
	//if ( aType == KEikDynamicLayoutVariantSwitch )
	//hard coded constant so it can be compiled with first edition
	
	if ( aType == 0x101F8121 )
	    {
	    iAppView->SetRect( ClientRect() );
	    }
	}


#ifdef __SERIES60_3X__
    void  CTestAppAppUi::HandleServerAppExit (TInt aReason)
	{
	//Handle the closing of the handler application
    MAknServerAppExitObserver::HandleServerAppExit( aReason );  	
	}
#else
    void CTestAppAppUi::NotifyExit(TExitMode aMode)    
	{
	//Handle the closing of the handler application
	//The mode can be set by the handler application by calling
	//iDoorObserver->NotifyExit(TExitMode);

	switch (aMode) 
	    {
	    
		/** Changes to the embedded document must be saved. */
	    case EKeepChanges:
	        {
	        //TODO
	        }
	        break;
	        
		/** Reverts back to the saved version of the embedded document, i.e. reloads the 
		whole document. */
	        case ERevertToSaved:
	        {
	        //TODO
	        }
	        break;
		/** No changes have been made to the embedded document. */
		case ENoChanges:
	        {
	        //TODO
	        }
	        break;
		/** The embedded document is empty. */
		case EEmpty:
	        {
	        //TODO
	        }
	        break;
	    default:
	        //TODO
	        break;
	    }
	}
#endif