/** @file auth.cpp
 * Contained the implementation of all exported APIs.
 */

/*
* ==============================================================================
*  Name        : auth.cpp
*  Part of     : Open C/Example code
*  Description : This is used to handle user authentication and auth database.
*
*  Version     : 1.0
*
*  Copyright (c) 2007 Nokia Corporation.
*  This material, including documentation and any related
*  computer programs, is protected by copyright controlled by
*  Nokia Corporation.
* ==============================================================================
*/

#include <e32cons.h>
#include <e32uid.h>
#include <string.h>
#include "wsddll.h"
#include "pls.h"

#ifdef __WINSCW__
const TUid KWsdDllUid3 = {0xA000131D};

// WSD object type for this DLL
struct TWsdData
{
	int count;     // Global variable
	char name[20]; // Global variable
};

#else
	int count = 0;             // Global variable
	char name[20] = "Default"; // Global variable
#endif

#ifdef __WINSCW__
// Initialisation function for WSD objects - supplied to Pls()
LOCAL_C int InitializeWsd(TWsdData* aArg)
{
	aArg->count = 0; // Initialise global count with 0
	strcpy(aArg->name,"Default");
	return 0;
}

// Function to fetch the WSD object for this process
LOCAL_C TWsdData* GetGlobals()
{

	// Access the PLS of this process
	TWsdData* p = Pls<TWsdData>(KWsdDllUid3, &InitializeWsd);
	return p;
}

#define name (p->name)
#define count (p->count)

#endif

EXPORT_C int GetDllInt()
{
#ifdef __WINSCW__
	TWsdData* p = GetGlobals();
#endif
	return count;

}

EXPORT_C void GetDllString(char *str)
{
#ifdef __WINSCW__
	TWsdData* p = GetGlobals();
#endif
	strcpy(str,name);

}

EXPORT_C void SetDllInt(const int i)
{
#ifdef __WINSCW__
	TWsdData* p = GetGlobals();
#endif
	count = i;

}

EXPORT_C void SetDllString(char * str)
{
#ifdef __WINSCW__
	TWsdData* p = GetGlobals();
#endif
	strcpy(name,str);

}


// end of file
