// Copyright (c) 2000-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// This example shows how to use multiple resource files with cross-referenced
// resources.  It depends on the resource file created for the MultiRead1 project.
// It introduces a second resource file, MultiRead2, which contains an LLINK
// to a resource defined in the MultiRead1 project. The important point to note is
// that the effect of introducing this second resource file is minimal: just
// another #include file; and the logic in doExampleL() would be identical whether
// the LLINK pointed to another resource in the same file or a different file.
//



#include "CommonToResourceFilesEx.h"
#include <multiread2.rsg> // user resources
#include "MultiRead.h"    // definition of multi-resource-reader class

// Do the example
void doExampleL()
	{
	_LIT(KFormat,"%S\n");

	// allocate multi-reader
	CMultipleResourceFileReader* multiReader =
			CMultipleResourceFileReader::NewLC();

	// open resource file on the emulator(__WINS__  is defined for the Windows emulator)
	// (leave if error)
	#if defined(__WINS__)
	// add MultiRead1 version 23
	_LIT(KZSystemDataBasigbRsc,"Z:\\Resource\\apps\\MultiRead1.rsc");
	multiReader->AddResourceFileL(KZSystemDataBasigbRsc,23);
	// add MultiRead2 version 17
	_LIT(KZSystemDataBasiguRsc,"Z:\\Resource\\apps\\MultiRead2.rsc");
	multiReader->AddResourceFileL(KZSystemDataBasiguRsc,17);
	#endif

	// open a resource file on the target phone
	// ( __EPOC32__ is defined for all target hardware platforms regardless of processor type/hardware architecture)
	#if defined(__EPOC32__)
	// add MultiRead1 version 23
	_LIT(KCSystemDataBasigbRsc,"Z:\\Resource\\apps\\MultiRead1.rsc");
	multiReader->AddResourceFileL(KCSystemDataBasigbRsc,23);
	
	// add MultiRead2 version 17
	_LIT(KCSystemDataBasiguRsc,"Z:\\Resource\\apps\\MultiRead2.rsc");
	multiReader->AddResourceFileL(KCSystemDataBasiguRsc,17);
	#endif
	
	// read resource that returns a reference to another resource
	HBufC8* refBuffer=multiReader->AllocReadLC(R_USER_HELLOREF);
	TResourceReader theReader;
	theReader.SetBuffer(refBuffer);
	TInt referencedId=theReader.ReadInt32(); // treat resource as integer
	CleanupStack::PopAndDestroy(); // refBuffer
	// read the other resource
	HBufC8* dataBuffer=multiReader->AllocReadLC(referencedId);
	TResourceReader reader;
	reader.SetBuffer(dataBuffer);
	TPtrC textdata = reader.ReadTPtrC();

	// write string to test console
	console->Printf(KFormat, &textdata);
	// clean up data buffer
	CleanupStack::PopAndDestroy(); // finished with dataBuffer
	// cleanup multi-reader
	CleanupStack::PopAndDestroy(); // multi-reader
	}
