// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#include <e32std.h>
#include "threadserverstart.h"
#include "threadserver.h"

/**
Thread entry-point function.
The ThreadServerStart object is passed as the thread parameter
**/
EXPORT_C TInt CThreadServer::StartThread(TAny* /*aPointer*/)
	{
	__UHEAP_MARK;
	//
	CTrapCleanup* cleanup=CTrapCleanup::New();
	TInt r=KErrNoMemory;
	if (cleanup)
		{
		TRAP(r,StartThreadL());
		delete cleanup;
		}
	//
	__UHEAP_MARKEND;
	return r;
	}
/**
	Function demonstrates how to start thread by using Rendezvous() call to 
	sync with the client
*/
void CThreadServer::StartThreadL()
	{
	//
	// create and install the active scheduler we need
	CActiveScheduler* s=new(ELeave) CActiveScheduler;
	CleanupStack::PushL(s);
	CActiveScheduler::Install(s);
	//
	// create the server (leave it on the cleanup stack)
	CThreadServer::NewLC();
	
	//rename the thread server by appending thread id 
	//in order to prevent same name re-create
	RenameServer();
	//
	// Initialisation complete, now signal the client
	RThread::Rendezvous(KErrNone);
	//
	// Ready to run
	CActiveScheduler::Start();
	//
	// Cleanup the server and scheduler
	CleanupStack::PopAndDestroy(2);
	}

//eof


