// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Include Files  
//

#include "libpthreadexample.h"
#include <e32base.h>
#include <e32std.h>
#include <e32cons.h>	// Console
#include <pthread.h>	//Used for all the functions with prefix pthread_
#include <f32file.h>
#include "unistd.h"		//USed for sleep()

//  Constants
_LIT(KTestFile,"c:\\newfile.txt");  //Text file as the shared resource

//  Global Variables
LOCAL_D CConsoleBase* console; // Write all messages to this
pthread_mutex_t  mutex;  //mutex 

/*
 * This function is the routine for threadOne. It writes "one" in the text file. 
 * A mutex is used to avoid race condition amongst the threads  
 */
void *TestFunction1L(void*)
	{
	// Start a file server session
	RFs aFs;
	User::LeaveIfError(aFs.Connect());
	
	RFile file;
	pthread_mutex_lock(&mutex);    //Lock the mutex for threadone. 
	TInt pos = 0;  	   
	for(int i=0; i<5; i++)			
		{
			//Push the file object on the cleanup stack before doing any file operation which could leave. 
			CleanupClosePushL(file); 
			file.Open(aFs,KTestFile,EFileRead|EFileWrite);
	
			_LIT8(KWriteBuf,"One, \n");
			file.Seek(ESeekEnd, pos );
			file.Write(pos ,KWriteBuf);
			CleanupStack::PopAndDestroy(&file);
			file.Close();
			User::After(1000000);			//Wait for 0.1 s to ensure a visible interthreading mechanism
		}
		aFs.Close();
		pthread_mutex_unlock(&mutex);	//Release the mutex . 
		return NULL;
	}
	
/*
 * This function is the routine for threadTwo. It writes "two" in the text file. 
 * A mutex is used to avoid race condition amongst the threads  
 */
void *TestFunction2L(void*)
	{
	// Start a file server session
	RFs aFs;	
	User::LeaveIfError(aFs.Connect());
	
	RFile file;		
	pthread_mutex_lock(&mutex); //Lock the mutex for threadone. 
	TInt pos = 0;
	for(int i=0; i<5; i++)
		{
			//Push the file object on the cleanup stack before doing any file operation which could leave. 
			CleanupClosePushL(file); 
			file.Open(aFs, KTestFile, EFileRead|EFileWrite);
			
			_LIT8(KWriteBuf, "Two, \n");
			file.Seek(ESeekEnd, pos );
			file.Write(pos, KWriteBuf);
			CleanupStack::PopAndDestroy(&file);
			file.Close();
			User::After(1000000); //Wait for 0.1 s to ensure a visible interthreading mechanism
		}	
	aFs.Close();
	pthread_mutex_unlock(&mutex);
	return NULL;
	}
	
/*
 * This function is the routine for threadThree. It writes "three" in the text file. 
 * A mutex is used to avoid race condition amongst the threads  
 */
void *TestFunction3L(void*)
	{
	// Start a file server session
	RFs aFs;
	User::LeaveIfError(aFs.Connect());
	
	RFile file;
	pthread_mutex_lock(&mutex);
	TInt pos = 0;
	for(int i=0; i<5;i++ )
		{
			//Push the file object on the cleanup stack before doing any file operation which could leave. 
			CleanupClosePushL(file); 
			file.Open(aFs,KTestFile,EFileRead|EFileWrite);
			
			_LIT8(KWriteBuf,"Three ,\n");
			file.Seek(ESeekEnd , pos );
			file.Write(pos ,KWriteBuf);
			CleanupStack::PopAndDestroy(&file);
			file.Close();
			User::After(1000000); //Wait for 0.1 s to ensure a visible interthreading mechanism 
		}
	aFs.Close();
	pthread_mutex_unlock(&mutex);
	return NULL;
	}
	
/*
* The following function creates three threads which starts executing as soon as it is created
* it creates a text file which is used as a shared resource . The main thread will wait till 
* child threads completes its execution . 
*/
int CreateThreadL()
	{	
	//Three threads declared.
	pthread_t threadOne;
	pthread_t threadTwo;
	pthread_t threadThree;
	
	_LIT(KMain ,"in main\n" ); 
	console->Write(KMain);
	//Start a file server session 
	RFs aFs;	
	User::LeaveIfError(aFs.Connect());
	
	//Create a text file which can be used as a shared resource. 
	RFile file;
	CleanupClosePushL(file); 
	file.Create(aFs ,KTestFile,EFileRead|EFileWrite);
	CleanupStack::PopAndDestroy(&file);
	file.Close(); 
	aFs.Close();
	//Create and initialize mutex for synchronization	
	if((pthread_mutex_init(&mutex,NULL)) != 0)
		{
			return -1;
		}	  
	
	//Create threadOne.. thread is in running state. 
	TInt err1 = pthread_create(&threadOne,NULL,TestFunction1L, NULL);
	User::LeaveIfError(err1);
	_LIT(KThreadOneCreated , "ThreadOne created\n");
	console->Write(KThreadOneCreated);
	
	//Create threadTwo.. thread is in running state.
	TInt err2 = pthread_create(&threadTwo,NULL,TestFunction2L, NULL);
	User::LeaveIfError(err2);
	_LIT(KThreadTwoCreated , "ThreadTwo created\n");
	console->Write(KThreadTwoCreated);
	
	//Create threadThree.. thread is in running state.
	TInt err3 = pthread_create(&threadThree,NULL,TestFunction3L, NULL);
	User::LeaveIfError(err3);
	_LIT(KThreadThreeCreated , "ThreadThree created\n");
	console->Write(KThreadThreeCreated);
	
	
	//------Main thread waits for other threads to complete ---- 
	_LIT(KWait , "Waiting for child threads to complete execution\n");
	console->Write(KWait);
	
	_LIT(KJoinError , "Error in pthread_join()");
	//Main thread waits for threadOne to complete execution
	if(pthread_join(threadOne, NULL) != 0)
		{
			console->Write(KJoinError);	 
		}
	else
		{
			_LIT(KRetThreadOne ,"Returned from threadone\n"); 
			console->Write(KRetThreadOne); //Control comes to main thread once threadOne completes execution.
		}

	//Main thread waits for threadTwo to complete execution
	if(pthread_join(threadTwo, NULL) != 0)
		{
			console->Write(KJoinError);
		}
	else
		{
			_LIT(KRetThreadTwo ,"Returned from threadtwo\n"); 
			console->Write(KRetThreadTwo); //Control comes to main thread once threadTwo completes execution.
		}
		
	//Main thread waits for threadThree to complete execution
	if(pthread_join(threadThree, NULL) != 0)
		{
			console->Write(KJoinError);	 
		}
	else 
		{
			_LIT(KRetThreadThree ,"Returned from threadthree\n"); 
			console->Write(KRetThreadThree); //Control comes to main thread once threadTwo completes execution.
		}
	//Clean up
	pthread_mutex_destroy(&mutex);
	return -1; 
	}
	
	//  Local Functions

LOCAL_C void MainL()
	{
	_LIT(KHello , "Welcome to the LibpThread example, we will create three threads and use them to print data to \\epoc32\\winscw\\c\\newfile.txt\n\n");
	console->Write(KHello);
	CreateThreadL();
	}

LOCAL_C void DoStartL()
	{
	MainL();
	}

	//  Global Functions

GLDEF_C TInt E32Main()
	{
	// Create cleanup stack
	__UHEAP_MARK;
	CTrapCleanup* cleanup = CTrapCleanup::New();
		// Create output console
	_LIT(KTextConsoleTitle, "Console");
	TRAPD(createError, console = Console::NewL(KTextConsoleTitle, TSize(KConsFullScreen,KConsFullScreen)));
	if (createError)
	return createError;
		// Run application code inside TRAP harness, wait keypress when terminated
	TRAPD(mainError, DoStartL());
	_LIT(KTextFailed, " failed, leave code = %d");
	if (mainError)
	console->Printf(KTextFailed, mainError);
	_LIT(KTextPressAnyKey, " [press any key]\n");
	console->Printf(KTextPressAnyKey);
	console->Getch();
	delete console;
	delete cleanup;
	__UHEAP_MARKEND;
	return KErrNone;
	}
	
