/** 
 *  @file MsgQCheck.cpp
 *  Description: Source file for MsgQLib's MsgQCheck API
 *  Copyright (c) 2007 Nokia Corporation.
 *  This material, including documentation and any related
 *  computer programs, is protected by copyright controlled by
 *  Nokia Corporation. 
 */

#include <errno.h>
#include <sys/msg.h>
#include "MsgQInternal.h"



/*****************************************************************************
*  MsgQCheck
*  Function: Function for checking how many messages are in a queue
*******************************************************************************/

EXPORT_C int MsgQCheck(ULONG qName, int* err) {
	MSGQ_INFO* pMsgQInfo = NULL;
	int nMsgs;
	struct  msqid_ds  qStatus ;

	if ((pMsgQInfo = MsgQTableLookup(qName)) != NULL) {
		//   get total count of msgs from the msg queue 
		if ((msgctl(pMsgQInfo->qId,IPC_STAT ,&qStatus)) >= 0 ) {
			nMsgs=qStatus.msg_qnum ;
			if (nMsgs == pMsgQInfo->numMsgs) {
				*err = OK;
				return(nMsgs);
			}
			else {
				*err = KMsgQLibQShortErr;
				return(pMsgQInfo->numMsgs);
			}
		}
		else
			*err=errno;
	}
	else
		*err = KMsgQLibQIdErr;
	return(ERROR);
}

