/** 
 *  @file MsgQMaxCheck.cpp
 *  Description: Source file for MsgQLib's MsgQMaxCheck API
 *  Copyright (c) 2007 Nokia Corporation.
 *  This material, including documentation and any related
 *  computer programs, is protected by copyright controlled by
 *  Nokia Corporation.
********************************************************************************************/

#include <_ansi.h>
#include "MsgQInternal.h"


/**************************************************************************
*  MsgQMaxCheck
*  Function: This function checks the maximum number of messages in a
***************************************************************************/

EXPORT_C int MsgQMaxCheck(ULONG qName, int* err) {
	MSGQ_INFO* pMsgQInfo = NULL;

	if ((pMsgQInfo = MsgQTableLookup(qName)) != NULL) {
		*err = OK;
		return (pMsgQInfo->maxNumMsgs);
	}
	else
		*err = KMsgQLibQIdErr;

	return(ERROR);
}

