/*
* ============================================================================
*  Name     : CTaskManagerEngineReader from TaskManagerEngineReader.cpp
*  Part of  : TaskManager
*  Created  : 15/03/2006 by Forum Nokia
*  Version  : 1.2
*  Copyright: Nokia Corporation
* ============================================================================
*/

// INCLUDE FILES
#include "TaskManager.pan"
#include "TaskManagerEngineReader.h"

#include <securesocket.h>

// ================= MEMBER FUNCTIONS =======================

// Constructor
CTaskManagerEngineReader::CTaskManagerEngineReader( MEngineNotifier& aNotifier )
: CActive( EPriorityStandard ), iSocket( NULL ), iNotifier( aNotifier )
	{
	}

// Destructor
CTaskManagerEngineReader::~CTaskManagerEngineReader()
	{
	Cancel();
	}

// ----------------------------------------------------
// CTaskManagerEngineReader::ConstructL()
// Second-phase constructor
// ----------------------------------------------------
//
void CTaskManagerEngineReader::ConstructL()
	{
	CActiveScheduler::Add( this );
	}

// ----------------------------------------------------
// CTaskManagerEngineReader::NewL()
// Two-phased construction.
// ----------------------------------------------------
//
CTaskManagerEngineReader* CTaskManagerEngineReader::NewL( MEngineNotifier& aNotifier )
	{
	CTaskManagerEngineReader* self = CTaskManagerEngineReader::NewLC( aNotifier );
	CleanupStack::Pop( self );
	return self;
	}

// ----------------------------------------------------
// CTaskManagerEngineReader::NewLC()
// Two-phased construction.
// ----------------------------------------------------
//
CTaskManagerEngineReader* CTaskManagerEngineReader::NewLC( MEngineNotifier& aNotifier )
	{
	CTaskManagerEngineReader* self = new (ELeave) CTaskManagerEngineReader( aNotifier );
	CleanupStack::PushL( self );
	self->ConstructL();
	return self;
	}

// ----------------------------------------------------
// CTaskManagerEngineReader::Start()
// Initiates the reader.
// ----------------------------------------------------
//
void CTaskManagerEngineReader::Start()
	{
	// Initiate a new read from socket into iBuffer
    if (!IsActive())
        {
        IssueRead();
        }
	}

// ----------------------------------------------------
// CTaskManagerEngineReader::DoCancel()
// Cancels an outstanding request.
// ----------------------------------------------------
//
void CTaskManagerEngineReader::DoCancel()
	{
	iSocket->CancelRecv();
	}

// ----------------------------------------------------
// CTaskManagerEngineReader::RunL()
// Handles an active objects request completion event.
// ----------------------------------------------------
//
void CTaskManagerEngineReader::RunL()
	{
	switch( iStatus.Int() )
		{
		case KErrNone:
			{
			// Something was read from socket. Pass it to upper levels
	        if( iNotifier.PackageReceivedL( iBuffer ) )
	            {
	            IssueRead(); // Immediately start another read
	            }
            
			break;
			}
		default:
		    {
		    Panic( ETaskManagerInvalidState );
		    break;
		    }
		}
	}

// ----------------------------------------------------
// CTaskManagerEngineReader::IssueRead()
// Initiate a single new read from socket.
// ----------------------------------------------------
//
void CTaskManagerEngineReader::IssueRead()
	{
	// This deletion is needed for some reason in S60 3rd Edition (at least for the emulator).
	// Otherwise the data in iBuffer will not get replaced on successive read operations to
	// the secure socket.
	iBuffer.Delete(0, iBuffer.Length());
    iSocket->RecvOneOrMore(iBuffer, iStatus, iDummyLength);
    SetActive();
    }

// ----------------------------------------------------
// CTaskManagerEngineReader::SetSecureSocket()
// Sets a new socket from which to read.
// ----------------------------------------------------
//
void CTaskManagerEngineReader::SetSecureSocket( CSecureSocket* aSocket )
    {
    iSocket = aSocket;
    }
    
// End of file
